/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.path;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.BnButton;
import org.beanfabrics.swing.customizer.path.PathBrowserPanel;
import org.beanfabrics.swing.customizer.path.PathChooserPM;
import org.beanfabrics.swing.customizer.util.CustomizerUtil;

public class PathChooserDialog
extends JDialog
implements View<PathChooserPM>,
ModelSubscriber {
    private JButton cancelButton;
    private BnButton okBnButton;
    private JPanel buttonPanel;
    private PathBrowserPanel pathChooserPanel;
    private JPanel centerPanel;
    private final Link link = new Link((View)this);
    private ModelProvider localProvider;

    public static PathChooserDialog create(Window parent) {
        if (parent instanceof Dialog) {
            return new PathChooserDialog((Dialog)parent);
        }
        return new PathChooserDialog((Frame)parent);
    }

    private PathChooserDialog(Dialog dialog) {
        super(dialog);
        this.init();
    }

    private PathChooserDialog(Frame frame) {
        super(frame);
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
        this.setBackground(this.getDefaultBackground());
    }

    protected ModelProvider getLocalProvider() {
        if (this.localProvider == null) {
            this.localProvider = new ModelProvider();
            this.localProvider.setPresentationModelType(PathChooserPM.class);
        }
        return this.localProvider;
    }

    public PathChooserPM getPresentationModel() {
        return (PathChooserPM)this.getLocalProvider().getPresentationModel();
    }

    public void setPresentationModel(PathChooserPM pModel) {
        this.getLocalProvider().setPresentationModel((PresentationModel)pModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            this.centerPanel.add((Component)this.getPathChooserPanel(), "Center");
            this.centerPanel.add((Component)this.getButtonPanel(), "South");
        }
        return this.centerPanel;
    }

    private PathBrowserPanel getPathChooserPanel() {
        if (this.pathChooserPanel == null) {
            this.pathChooserPanel = new PathBrowserPanel();
            this.pathChooserPanel.setPath(new Path("this.pathBrowser"));
            this.pathChooserPanel.setModelProvider((IModelProvider)this.getLocalProvider());
        }
        return this.pathChooserPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWidths = new int[]{0, 7};
            this.buttonPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 5);
            this.buttonPanel.add((Component)this.getOkBnButton(), gridBagConstraints);
            GridBagConstraints gridBagConstraints_1 = new GridBagConstraints();
            gridBagConstraints_1.anchor = 13;
            gridBagConstraints_1.weightx = 1.0;
            gridBagConstraints_1.weighty = 0.0;
            gridBagConstraints_1.insets = new Insets(4, 4, 4, 0);
            gridBagConstraints_1.gridy = 0;
            gridBagConstraints_1.gridx = 1;
            this.buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints_1);
        }
        return this.buttonPanel;
    }

    private BnButton getOkBnButton() {
        if (this.okBnButton == null) {
            this.okBnButton = new BnButton();
            this.okBnButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PathChooserDialog.this.dispose();
                }
            });
            this.okBnButton.setPath(new Path("this.apply"));
            this.okBnButton.setModelProvider((IModelProvider)this.getLocalProvider());
            this.okBnButton.setText("Ok");
        }
        return this.okBnButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PathChooserDialog.this.dispose();
                }
            });
            this.cancelButton.setText("Cancel");
        }
        return this.cancelButton;
    }

    private Color getDefaultBackground() {
        if (CustomizerUtil.isAquaLookAndFeel()) {
            return new Color(232, 232, 232);
        }
        return this.getBackground();
    }
}

