/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.path;

import org.beanfabrics.Path;
import org.beanfabrics.meta.PathNode;
import org.beanfabrics.meta.TypeInfo;
import org.beanfabrics.model.OperationPM;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.model.TextPM;
import org.beanfabrics.support.Operation;
import org.beanfabrics.support.SortOrder;
import org.beanfabrics.support.Validation;
import org.beanfabrics.swing.customizer.path.PathChooserController;
import org.beanfabrics.swing.customizer.path.PathChooserPM;
import org.beanfabrics.swing.customizer.path.PathContext;
import org.beanfabrics.swing.customizer.util.CustomizerUtil;

public class PathPM
extends TextPM {
    OperationPM choosePath = new OperationPM();
    private PathNode rootElementInfo;
    private TypeInfo requiredModelTypeInfo;

    public PathPM() {
        PMManager.setup((PresentationModel)this);
    }

    public void setPathContext(PathContext pathContext) {
        this.rootElementInfo = pathContext.root;
        this.requiredModelTypeInfo = pathContext.requiredModelTypeInfo;
        this.revalidateProperties();
    }

    public Path getData() {
        return Path.parse((String)this.getText());
    }

    public void setData(Path path) {
        this.setText(Path.getPathString((Path)path));
    }

    @Operation
    void choosePath() {
        final PathChooserController ctrl = CustomizerUtil.createPathChooser(this.getContext(), new PathContext(this.rootElementInfo, this.requiredModelTypeInfo), this.getData());
        ctrl.getPresentationModel().onApply(new PathChooserPM.OnApplyHandler(){

            @Override
            public void apply() {
                PathPM.this.setData(ctrl.getPresentationModel().getData());
            }
        });
        ctrl.getView().setVisible(true);
    }

    @Validation(path={"choosePath"})
    boolean canChoosePath() {
        return this.rootElementInfo != null;
    }

    @Validation
    @SortOrder(value=1)
    boolean isSyntacticallyCorrect() {
        try {
            new Path(this.getText());
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    @Validation(message="This path points into the void")
    @SortOrder(value=2)
    boolean isComplete() {
        Path path = new Path(this.getText());
        return this.rootElementInfo == null || this.rootElementInfo.getNode(path) != null;
    }

    @Validation(message="The object at the end of this path does not match the required type")
    @SortOrder(value=3)
    boolean isCorrect() {
        Path path = new Path(this.getText());
        return this.rootElementInfo == null || this.requiredModelTypeInfo == null || this.requiredModelTypeInfo.isAssignableFrom(this.rootElementInfo.getNode(path).getTypeInfo());
    }
}

