/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.table;

import org.beanfabrics.Path;
import org.beanfabrics.meta.PathNode;
import org.beanfabrics.model.OperationPM;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.support.OnChange;
import org.beanfabrics.support.Operation;
import org.beanfabrics.support.Validation;
import org.beanfabrics.swing.customizer.AbstractCustomizerPM;
import org.beanfabrics.swing.customizer.CustomizerBase;
import org.beanfabrics.swing.customizer.path.PathPM;
import org.beanfabrics.swing.customizer.table.ColumnListConfigurationConstroller;
import org.beanfabrics.swing.customizer.table.ColumnListConfigurationPM;
import org.beanfabrics.swing.customizer.util.CustomizerUtil;
import org.beanfabrics.swing.table.BnColumn;
import org.beanfabrics.swing.table.BnTable;

public class BnTableCustomizerPM
extends AbstractCustomizerPM {
    private BnTable bnTable;
    protected final PathPM path = new PathPM();
    protected final OperationPM configureColumns = new OperationPM();

    public BnTableCustomizerPM() {
        PMManager.setup((PresentationModel)this);
    }

    @Override
    public void setCustomizer(CustomizerBase customizer) {
        super.setCustomizer(customizer);
        this.setBnTable((BnTable)customizer.getObject());
    }

    private void setBnTable(BnTable bnTable) {
        this.bnTable = bnTable;
        this.path.setData(bnTable.getPath());
        this.path.setPathContext(CustomizerUtil.getPathContextToCustomizeModelSubscriber(bnTable));
        this.revalidateProperties();
    }

    @OnChange(path={"path"})
    void applyPath() {
        if (this.path.isValid() && this.bnTable != null && this.getCustomizer() != null) {
            Path oldValue = this.bnTable.getPath();
            Path newValue = this.path.getData();
            this.bnTable.setPath(newValue);
            this.getCustomizer().firePropertyChange("path", oldValue, newValue);
        }
    }

    @Validation(path={"configureColumns"})
    public boolean canConfigureColumns() {
        return !this.path.isEmpty() && this.path.isValid();
    }

    @Operation
    public void configureColumns() {
        this.configureColumns.check();
        PathNode rowPMNode = this.resolveRowPmNode();
        final ColumnListConfigurationConstroller ctrl = new ColumnListConfigurationConstroller(this.getContext(), rowPMNode);
        ctrl.getPresentationModel().setData(this.bnTable.getColumns());
        ctrl.getPresentationModel().onApply(new ColumnListConfigurationPM.OnApplyHandler(){

            @Override
            public void apply() {
                BnTableCustomizerPM.this.applyColumns(ctrl.getPresentationModel().getData());
            }
        });
        ctrl.getView().setModal(true);
        ctrl.getView().setVisible(true);
    }

    protected PathNode resolveRowPmNode() {
        return CustomizerUtil.asRootNode(CustomizerUtil.getElementTypeOfSubscribedOrActualIListPM(this.bnTable));
    }

    protected void applyColumns(BnColumn[] newValue) {
        BnColumn[] oldValue = this.bnTable.getColumns();
        this.bnTable.setColumns(newValue);
        this.getCustomizer().firePropertyChange("columns", oldValue, newValue);
    }
}

