/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.util;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class RowNumberTable
extends JTable
implements ChangeListener,
PropertyChangeListener {
    private JTable main;
    private TableModel mainTableModel;
    private TableModelListener mainTableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            RowNumberTable.this.tableChanged(new TableModelEvent(RowNumberTable.this.dataModel, e.getFirstRow(), e.getLastRow(), -1));
            RowNumberTable.this.invalidate();
        }
    };

    public RowNumberTable(JTable table) {
        this.main = table;
        this.main.addPropertyChangeListener(this);
        this.setMainTableModel(this.main.getModel());
        this.setFocusable(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setSelectionModel(this.main.getSelectionModel());
        TableColumn column = new TableColumn();
        column.setHeaderValue(" ");
        this.addColumn(column);
        column.setCellRenderer(new RowNumberRenderer());
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public void setPreferredRowHeaderWidth(int value) {
        this.getColumnModel().getColumn(0).setPreferredWidth(value);
        this.getColumnModel().getColumn(0).setWidth(value);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public int getPreferredRowHeaderWidth() {
        return this.getColumnModel().getColumn(0).getPreferredWidth();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container c = this.getParent();
        if (c instanceof JViewport) {
            JViewport viewport = (JViewport)c;
            viewport.addChangeListener(this);
        }
    }

    @Override
    public int getRowCount() {
        return this.main.getRowCount();
    }

    @Override
    public int getRowHeight(int row) {
        int rowHeight = this.main.getRowHeight(row);
        if (rowHeight != super.getRowHeight(row)) {
            super.setRowHeight(row, rowHeight);
        }
        return rowHeight;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return Integer.toString(row + 1);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JViewport viewport = (JViewport)e.getSource();
        JScrollPane scrollPane = (JScrollPane)viewport.getParent();
        scrollPane.getVerticalScrollBar().setValue(viewport.getViewPosition().y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("selectionModel".equals(e.getPropertyName())) {
            this.setSelectionModel(this.main.getSelectionModel());
        }
        if ("rowHeight".equals(e.getPropertyName())) {
            this.repaint();
        }
        if ("model".equals(e.getPropertyName())) {
            this.setMainTableModel(this.main.getModel());
        }
    }

    private void setMainTableModel(TableModel newModel) {
        if (newModel == this.mainTableModel) {
            return;
        }
        if (this.mainTableModel != null) {
            this.mainTableModel.removeTableModelListener(this.mainTableModelListener);
        }
        this.mainTableModel = newModel;
        if (this.mainTableModel != null) {
            this.mainTableModel.addTableModelListener(this.mainTableModelListener);
        }
        this.tableChanged(new TableModelEvent(this.dataModel, -1));
    }

    private static class RowNumberRenderer
    extends DefaultTableCellRenderer {
        public RowNumberRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            if (isSelected) {
                this.setFont(this.getFont().deriveFont(1));
            }
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

