/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.internal;

import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JCheckBox;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ConversionException;
import org.beanfabrics.model.IBooleanPM;
import org.beanfabrics.swing.ErrorIconPainter;

public class BooleanPMCheckBox
extends JCheckBox
implements View<IBooleanPM> {
    private IBooleanPM pModel;
    private final WeakPropertyChangeListener listener = new MyWeakPropertyChangeListener();
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();

    public BooleanPMCheckBox() {
        this.setEnabled(false);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BooleanPMCheckBox.this.isConnected()) {
                    return;
                }
                boolean newValue = BooleanPMCheckBox.this.isSelected();
                BooleanPMCheckBox.this.pModel.setBoolean(Boolean.valueOf(newValue));
            }
        });
    }

    public BooleanPMCheckBox(IBooleanPM pModel) {
        this();
        this.setPresentationModel(pModel);
    }

    public IBooleanPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IBooleanPM newModel) {
        IBooleanPM oldModel = this.pModel;
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.pModel = null;
        this.refresh();
        this.pModel = newModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    public boolean isConnected() {
        return this.pModel != null;
    }

    private void refresh() {
        if (this.pModel == null) {
            this.setSelected(false);
            this.setToolTipText(null);
            this.setEnabled(false);
        } else {
            try {
                Boolean value = this.pModel.getBoolean();
                if (value != null) {
                    this.setSelected(value);
                }
            }
            catch (ConversionException ex) {
                // empty catch block
            }
            String tooltip = this.pModel.isValid() ? this.pModel.getDescription() : this.pModel.getValidationState().getMessage();
            this.setToolTipText(tooltip);
            this.setEnabled(this.pModel.isEditable());
        }
        this.repaint();
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        result.setHorizontalAlignment(this.invertHorizontalTextPosition(this.getHorizontalTextPosition()));
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        IBooleanPM pModel = this.getPresentationModel();
        if (pModel == null) {
            return false;
        }
        return !pModel.isValid();
    }

    @Override
    public void setHorizontalTextPosition(int textPosition) {
        super.setHorizontalTextPosition(textPosition);
        if (this.errorIconPainter != null) {
            this.errorIconPainter.setHorizontalAlignment(this.invertHorizontalTextPosition(textPosition));
        }
    }

    private int invertHorizontalTextPosition(int textPosition) {
        switch (textPosition) {
            case 2: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 10;
            }
        }
        return textPosition;
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            BooleanPMCheckBox.this.refresh();
        }
    }
}

