/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.internal;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JToggleButton;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ConversionException;
import org.beanfabrics.model.IBooleanPM;

public class BooleanPMToggleButton
extends JToggleButton
implements View<IBooleanPM> {
    private IBooleanPM pModel;
    private boolean textSetManually = false;
    private final PropertyChangeListener listener = new MyWeakPropertyChangeListener();

    public BooleanPMToggleButton() {
        this.setEnabled(false);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (BooleanPMToggleButton.this.isConnected()) {
                    BooleanPMToggleButton.this.pModel.setBoolean(Boolean.valueOf(BooleanPMToggleButton.this.isSelected()));
                }
            }
        });
    }

    public BooleanPMToggleButton(IBooleanPM pModel) {
        this();
        this.setPresentationModel(pModel);
    }

    @Override
    public void setText(String text) {
        this.textSetManually = text != null;
        super.setText(text);
        this.refresh();
    }

    public IBooleanPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IBooleanPM newModel) {
        IBooleanPM oldModel = this.pModel;
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.listener);
        }
        this.pModel = newModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.listener);
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    public boolean isConnected() {
        return this.pModel != null;
    }

    private void refresh() {
        if (this.pModel == null) {
            this.setSelected(false);
            this.setToolTipText(null);
            this.setEnabled(false);
            if (!this.textSetManually) {
                super.setText(null);
            }
        } else {
            try {
                Boolean value = this.pModel.getBoolean();
                if (value != null) {
                    this.setSelected(value);
                }
            }
            catch (ConversionException ex) {
                // empty catch block
            }
            String tooltip = this.pModel.isValid() ? this.pModel.getDescription() : this.pModel.getValidationState().getMessage();
            if (!this.textSetManually) {
                String title = this.pModel.getTitle();
                super.setText(title);
            }
            this.setToolTipText(tooltip);
            this.setEnabled(true);
        }
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            BooleanPMToggleButton.this.refresh();
        }
    }
}

