/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.internal;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.log.Logger;
import org.beanfabrics.log.LoggerFactory;
import org.beanfabrics.model.IOperationPM;
import org.beanfabrics.util.ExceptionUtil;

public class OperationPMAction
extends AbstractAction
implements View<IOperationPM> {
    private static final Logger LOG = LoggerFactory.getLogger(OperationPMAction.class);
    private IOperationPM pModel;
    private WeakPropertyChangeListener listener = new MyWeakPropertyChangeListener();

    public OperationPMAction() {
    }

    public OperationPMAction(IOperationPM pModel) {
        this.setPresentationModel(pModel);
    }

    public IOperationPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IOperationPM newModel) {
        IOperationPM oldModel = this.pModel;
        if (this.isConnected()) {
            this.pModel.removePropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.pModel = newModel;
        if (newModel != null) {
            this.pModel.addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    boolean isConnected() {
        return this.pModel != null;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.isConnected()) {
            if (this.isEnabled()) {
                try {
                    this.execute();
                }
                catch (Throwable t) {
                    ExceptionUtil.getInstance().handleException("Error during invocation of pModel", t);
                }
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("OperationPMAction is not connected");
        }
    }

    protected boolean execute() throws Throwable {
        return this.pModel.execute();
    }

    protected void refresh() {
        if (this.isConnected()) {
            boolean isValid = this.pModel.isValid();
            this.setEnabled(isValid);
            this.setToolTipText(isValid ? this.pModel.getDescription() : this.pModel.getValidationState().getMessage());
            Icon icon = this.pModel.getIcon();
            this.setIcon(icon);
            String title = this.pModel.getTitle();
            this.setText(title);
        } else {
            this.setEnabled(false);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setText(null);
        }
    }

    private void setText(String title) {
        this.putValue("Name", title);
    }

    private void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    private void setToolTipText(String value) {
        this.putValue("ShortDescription", value);
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            OperationPMAction.this.refresh();
        }
    }
}

