/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.internal;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JButton;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.IOperationPM;
import org.beanfabrics.util.ExceptionUtil;

public class OperationPMButton
extends JButton
implements View<IOperationPM> {
    private IOperationPM pModel;
    private boolean autoExecute = true;
    private boolean iconSetManually = false;
    private boolean textSetManually = false;
    private final WeakPropertyChangeListener listener = new MyWeakPropertyChangeListener();

    public OperationPMButton() {
        this.init();
    }

    public OperationPMButton(IOperationPM pModel) {
        this();
        this.setPresentationModel(pModel);
    }

    private void init() {
        this.setEnabled(false);
    }

    public IOperationPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IOperationPM newModel) {
        IOperationPM oldModel = this.pModel;
        if (this.isConnected()) {
            this.pModel.removePropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.pModel = newModel;
        if (newModel != null) {
            this.pModel.addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    boolean isConnected() {
        return this.pModel != null;
    }

    @Override
    protected void fireActionPerformed(ActionEvent evt) {
        if (this.isConnected() && this.isAutoExecute()) {
            try {
                boolean doContinue = this.execute();
                if (doContinue) {
                    super.fireActionPerformed(evt);
                }
            }
            catch (Throwable t) {
                ExceptionUtil.getInstance().handleException("Error during invocation of pModel", t);
            }
        } else {
            super.fireActionPerformed(evt);
        }
    }

    protected boolean execute() throws Throwable {
        return this.pModel.execute();
    }

    protected void refresh() {
        if (this.isConnected()) {
            boolean isValid = this.pModel.isValid();
            this.setEnabled(isValid);
            this.setToolTipText(isValid ? this.pModel.getDescription() : this.pModel.getValidationState().getMessage());
            if (!this.iconSetManually) {
                Icon icon = this.pModel.getIcon();
                super.setIcon(icon);
            }
            if (!this.textSetManually) {
                String title = this.pModel.getTitle();
                super.setText(title);
            }
        } else {
            this.setEnabled(false);
            this.setToolTipText(null);
            if (!this.iconSetManually) {
                super.setIcon(null);
            }
            if (!this.textSetManually) {
                super.setText(null);
            }
        }
    }

    public boolean isAutoExecute() {
        return this.autoExecute;
    }

    public void setAutoExecute(boolean autoExecute) {
        this.autoExecute = autoExecute;
    }

    @Override
    public void setIcon(Icon icon) {
        this.iconSetManually = icon != null;
        super.setIcon(icon);
        this.refresh();
    }

    @Override
    public void setText(String text) {
        this.textSetManually = text != null;
        super.setText(text);
        this.refresh();
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            OperationPMButton.this.refresh();
        }
    }
}

