/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.internal;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.swing.BnComboBoxEditor;
import org.beanfabrics.swing.ErrorIconPainter;
import org.beanfabrics.swing.KeyBindingProcessor;

public class TextPMComboBox
extends JComboBox
implements KeyBindingProcessor,
View<ITextPM> {
    private static final Point DEFAULT_ERROR_ICON_OFFSET = new Point(-20, 0);
    private ITextPM pModel;
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();
    private final PropertyChangeListener propertyListener = new MyWeakPropertyChangeListener();
    private final ActionListener clearAction = new ClearActionListener();

    public TextPMComboBox() {
        this.setEnabled(false);
        this.setModel(this.createDefaultModel());
        this.registerKeyboardAction(this.clearAction, KeyStroke.getKeyStroke(8, 0), 0);
        this.registerKeyboardAction(this.clearAction, KeyStroke.getKeyStroke(127, 0), 0);
    }

    public TextPMComboBox(ITextPM pModel) {
        this();
        this.setPresentationModel(pModel);
    }

    public ITextPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(ITextPM newModel) {
        ITextPM oldModel = this.pModel;
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.propertyListener);
        }
        this.pModel = newModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.propertyListener);
            this.setEditor(this.createBnComboBoxEditor());
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    protected BnComboBoxEditor createBnComboBoxEditor() {
        return new BnComboBoxEditor(this);
    }

    public boolean isConnected() {
        return this.pModel != null;
    }

    protected boolean hasOptions() {
        return this.isConnected() && this.pModel.getOptions() != null;
    }

    protected void refresh() {
        ITextPM pModel = this.getPresentationModel();
        if (pModel != null) {
            this.setEnabled(pModel.isEditable());
            this.setToolTipText(!pModel.isValid() ? pModel.getValidationState().getMessage() : pModel.getDescription());
        } else {
            this.setToolTipText(null);
            this.setEnabled(false);
        }
        this.repaint();
    }

    protected TextEditorComboBoxModel createDefaultModel() {
        return new TextEditorComboBoxModel();
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        result.setOffset(DEFAULT_ERROR_ICON_OFFSET);
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        if (this.isEditable()) {
            return false;
        }
        ITextPM pModel = this.getPresentationModel();
        if (pModel == null) {
            return false;
        }
        return !pModel.isValid();
    }

    @Override
    public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean result = super.processKeyBinding(ks, e, condition, pressed);
        if (!result) {
            this.selectWithKeyChar(ks.getKeyChar());
        }
        return result;
    }

    protected class TextEditorComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        protected TextEditorComboBoxModel() {
        }

        @Override
        public Object getElementAt(int index) {
            if (!TextPMComboBox.this.isConnected()) {
                return null;
            }
            if (index < 0 || index >= TextPMComboBox.this.pModel.getOptions().size()) {
                return null;
            }
            return TextPMComboBox.this.pModel.getOptions().getValue(index);
        }

        @Override
        public int getSize() {
            if (!TextPMComboBox.this.isConnected()) {
                return 0;
            }
            if (TextPMComboBox.this.pModel.getOptions() == null) {
                return 0;
            }
            return TextPMComboBox.this.pModel.getOptions().size();
        }

        @Override
        public Object getSelectedItem() {
            if (!TextPMComboBox.this.isConnected()) {
                return null;
            }
            return TextPMComboBox.this.pModel.getText();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == null && this.getSelectedItem() == null) {
                return;
            }
            if (anItem != null && anItem.equals(this.getSelectedItem())) {
                return;
            }
            TextPMComboBox.this.pModel.setText(anItem != null ? anItem.toString() : "");
            this.fireContentsChanged(this, -1, -1);
        }

        public void refresh() {
            this.fireContentsChanged(this, -1, -1);
        }
    }

    private class ClearActionListener
    implements ActionListener,
    Serializable {
        private ClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int items = TextPMComboBox.this.getItemCount();
            for (int i = 0; i < items; ++i) {
                Object item = TextPMComboBox.this.getItemAt(i);
                if (!"".trim().equals(item)) continue;
                TextPMComboBox.this.setSelectedIndex(i);
                break;
            }
        }
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            TextPMComboBox.this.refresh();
            ((TextEditorComboBoxModel)TextPMComboBox.this.getModel()).refresh();
        }
    }
}

