/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.list;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.list.BnListModel;
import org.beanfabrics.swing.list.BnListSelectionModel;
import org.beanfabrics.swing.list.CellConfig;
import org.beanfabrics.swing.list.cellrenderer.BnListCellRenderer;

public class BnList
extends JList
implements View<IListPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private IListPM<? extends PresentationModel> presentationModel;
    private CellConfig cellConfig;

    public BnList() {
        this.setCellRenderer(this.createDefaultCellRenderer());
    }

    protected ListCellRenderer createDefaultCellRenderer() {
        return new BnListCellRenderer();
    }

    public IListPM getPresentationModel() {
        return this.presentationModel;
    }

    public void setPresentationModel(IListPM newModel) {
        IListPM<? extends PresentationModel> oldModel = this.presentationModel;
        if (newModel == oldModel) {
            return;
        }
        this.disconnect();
        this.presentationModel = newModel;
        this.connect();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    private boolean isConnected() {
        return this.presentationModel != null;
    }

    public CellConfig getCellConfig() {
        return this.cellConfig;
    }

    public void setCellConfig(CellConfig cellConfig) {
        CellConfig old = this.cellConfig;
        this.disconnect();
        this.cellConfig = cellConfig;
        this.connect();
        super.firePropertyChange("cellConfig", old, cellConfig);
    }

    protected void connect() {
        if (this.presentationModel == null || this.cellConfig == null) {
            return;
        }
        this.setModel(new BnListModel(this.presentationModel, this.cellConfig));
        int currentSelectionMode = this.getSelectionModel().getSelectionMode();
        BnListSelectionModel newModel = new BnListSelectionModel(this.presentationModel);
        newModel.setSelectionMode(currentSelectionMode);
        this.setSelectionModel(newModel);
    }

    protected void disconnect() {
        ListSelectionModel selModel = this.getSelectionModel();
        int currentSelectionMode = selModel.getSelectionMode();
        if (selModel instanceof BnListSelectionModel) {
            ((BnListSelectionModel)selModel).dismiss();
        }
        this.setSelectionModel(this.createSelectionModel());
        this.getSelectionModel().setSelectionMode(currentSelectionMode);
        ListModel listModel = this.getModel();
        if (listModel instanceof BnListModel) {
            ((BnListModel)listModel).dismiss();
        }
        this.setModel(new DefaultListModel());
    }
}

