/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.list;

import java.io.Serializable;
import javax.swing.AbstractListModel;
import org.beanfabrics.Path;
import org.beanfabrics.PathEvaluation;
import org.beanfabrics.event.ElementChangedEvent;
import org.beanfabrics.event.ElementsAddedEvent;
import org.beanfabrics.event.ElementsDeselectedEvent;
import org.beanfabrics.event.ElementsRemovedEvent;
import org.beanfabrics.event.ElementsReplacedEvent;
import org.beanfabrics.event.ElementsSelectedEvent;
import org.beanfabrics.event.ListListener;
import org.beanfabrics.event.WeakListListener;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.list.CellConfig;

public class BnListModel
extends AbstractListModel {
    private final IListPM list;
    private final CellConfig cellConfig;
    private final ListListener listener = new MyWeakListListener();

    public BnListModel(IListPM listCell, CellConfig cellConfig) {
        if (listCell == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        this.list = listCell;
        this.list.addListListener(this.listener);
        this.cellConfig = cellConfig;
    }

    public void dismiss() {
        this.list.removeListListener(this.listener);
    }

    public CellConfig getCellConfig() {
        return this.cellConfig;
    }

    @Override
    public Object getElementAt(int index) {
        PresentationModel rowMdl = this.list.getAt(index);
        return PathEvaluation.evaluateOrNull((PresentationModel)rowMdl, (Path)this.cellConfig.getPath());
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public IListPM getListCell() {
        return this.list;
    }

    private class MyWeakListListener
    implements WeakListListener,
    Serializable {
        private MyWeakListListener() {
        }

        public void elementsSelected(ElementsSelectedEvent evt) {
        }

        public void elementsDeselected(ElementsDeselectedEvent evt) {
        }

        public void elementChanged(ElementChangedEvent evt) {
            BnListModel.this.fireContentsChanged(evt.getSource(), evt.getIndex(), evt.getIndex());
        }

        public void elementsReplaced(ElementsReplacedEvent evt) {
            BnListModel.this.fireContentsChanged(evt.getSource(), evt.getBeginIndex(), evt.getBeginIndex() + evt.getLength() - 1);
        }

        public void elementsAdded(ElementsAddedEvent evt) {
            BnListModel.this.fireIntervalAdded(evt.getSource(), evt.getBeginIndex(), evt.getBeginIndex() + evt.getLength() - 1);
        }

        public void elementsRemoved(ElementsRemovedEvent evt) {
            BnListModel.this.fireIntervalRemoved(evt.getSource(), evt.getBeginIndex(), evt.getBeginIndex() + evt.getLength() - 1);
        }
    }
}

