/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.list.cellrenderer;

import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.list.cellrenderer.EmptyRenderer;
import org.beanfabrics.swing.list.cellrenderer.IconPMListCellRenderer;
import org.beanfabrics.swing.list.cellrenderer.PMListCellRenderer;
import org.beanfabrics.swing.list.cellrenderer.TextPMListCellRenderer;

public class BnListCellRenderer
implements ListCellRenderer,
Serializable {
    private final ListCellRenderer FALLBACK_RENDERER = new EmptyRenderer();
    private final List<PMListCellRenderer> installedRenderers = new ArrayList<PMListCellRenderer>();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof PresentationModel) {
            for (PMListCellRenderer renderer : this.installedRenderers) {
                if (!renderer.supportsPresentationModel((PresentationModel)value)) continue;
                return renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        }
        return this.FALLBACK_RENDERER.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
    }

    public BnListCellRenderer() {
        this.installDefaultRenderers();
    }

    private void installDefaultRenderers() {
        this.installedRenderers.add(new TextPMListCellRenderer());
        this.installedRenderers.add(new IconPMListCellRenderer());
    }

    public List<PMListCellRenderer> getInstalledRenderers() {
        return this.installedRenderers;
    }
}

