/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.list.cellrenderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.beanfabrics.model.IBooleanPM;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.ErrorIconPainter;
import org.beanfabrics.swing.list.cellrenderer.PMListCellRenderer;

public class BooleanPMListCellRenderer
extends JPanel
implements PMListCellRenderer {
    private CellRendererPane cellRendererPane = new CellRendererPane();
    private JCheckBox cb = new JCheckBox();
    private DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();
    private IBooleanPM model;
    private JComponent rendererComponent;

    public BooleanPMListCellRenderer() {
        this.cb.setHorizontalAlignment(0);
        this.cb.setBorderPainted(false);
        this.cb.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.cb, "Center");
    }

    @Override
    public boolean supportsPresentationModel(PresentationModel pModel) {
        return pModel instanceof IBooleanPM;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof IBooleanPM)) {
            return null;
        }
        this.model = (IBooleanPM)value;
        Boolean bvalue = false;
        if (this.model.getBoolean() != null) {
            bvalue = this.model.getBoolean();
        }
        this.cb.setSelected(bvalue);
        if (this.isNimbus()) {
            if (this.rendererComponent != null) {
                this.rendererComponent.setBackground(null);
            }
            this.rendererComponent = (JComponent)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
            if (!isSelected && index % 2 != 0) {
                this.rendererComponent.setBackground(Color.white);
            }
        } else {
            this.rendererComponent = (JComponent)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
        }
        return this;
    }

    private boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.rendererComponent != null) {
            this.rendererComponent.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.rendererComponent != null) {
            this.rendererComponent.setForeground(fg);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.cellRendererPane.paintComponent(g, this.rendererComponent, this, 0, 0, this.getWidth(), this.getHeight());
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        if (this.model == null) {
            return false;
        }
        return !this.model.isValid();
    }
}

