/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.list.cellrenderer;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.beanfabrics.model.IIconPM;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.ErrorIconPainter;
import org.beanfabrics.swing.list.cellrenderer.PMListCellRenderer;

public class IconPMListCellRenderer
extends DefaultListCellRenderer
implements PMListCellRenderer {
    private IIconPM model;
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();

    public IconPMListCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setInheritsPopupMenu(true);
    }

    @Override
    public boolean supportsPresentationModel(PresentationModel pModel) {
        return pModel instanceof IIconPM;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.setText("");
        if (value != null && value instanceof IIconPM) {
            this.model = (IIconPM)value;
            this.setIcon(this.model.getIcon());
            this.setToolTipText(!this.model.isValid() ? this.model.getValidationState().getMessage() : this.model.getDescription());
        } else {
            this.setIcon(null);
            this.setToolTipText(null);
        }
        return this;
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        result.setHorizontalAlignment(this.invertHorizontalAlignment(this.getHorizontalAlignment()));
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        if (this.model == null) {
            return false;
        }
        return !this.model.isValid();
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        super.setHorizontalAlignment(alignment);
        if (this.errorIconPainter != null) {
            this.errorIconPainter.setHorizontalAlignment(this.invertHorizontalAlignment(alignment));
        }
    }

    private int invertHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 2: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 10;
            }
        }
        return alignment;
    }
}

