/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.list.cellrenderer;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.beanfabrics.model.IIconPM;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.ErrorIconPainter;
import org.beanfabrics.swing.list.cellrenderer.PMListCellRenderer;

public class TextPMListCellRenderer
extends DefaultListCellRenderer
implements PMListCellRenderer {
    private ITextPM model;
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();

    public TextPMListCellRenderer() {
        this.setInheritsPopupMenu(true);
    }

    @Override
    public boolean supportsPresentationModel(PresentationModel pModel) {
        return pModel instanceof ITextPM;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null && value instanceof ITextPM) {
            this.model = (ITextPM)value;
            this.setText(this.model.getText());
            this.setToolTipText(!this.model.isValid() ? this.model.getValidationState().getMessage() : this.model.getDescription());
            if (this.model instanceof IIconPM) {
                IIconPM iconCell = (IIconPM)this.model;
                this.setIcon(iconCell.getIcon());
            } else {
                this.setIcon(null);
            }
        } else {
            this.setText("");
            this.setToolTipText(null);
            if (this.getIcon() != null) {
                this.setIcon(null);
            }
        }
        return this;
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        result.setHorizontalAlignment(this.invertHorizontalAlignment(this.getHorizontalAlignment()));
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        if (this.model == null) {
            return false;
        }
        return !this.model.isValid();
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        super.setHorizontalAlignment(alignment);
        if (this.errorIconPainter != null) {
            this.errorIconPainter.setHorizontalAlignment(this.invertHorizontalAlignment(alignment));
        }
    }

    private int invertHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 2: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 10;
            }
        }
        return alignment;
    }
}

