/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table;

import java.util.ArrayList;
import java.util.List;
import org.beanfabrics.Path;
import org.beanfabrics.swing.table.BnColumn;

public class BnColumnBuilder {
    public static final int ALIGNMENT_LEFT = 2;
    public static final int ALIGNMENT_RIGHT = 4;
    public static final int ALIGNMENT_TRAILING = 11;
    public static final int ALIGNMENT_LEADING = 10;
    public static final int ALIGNMENT_CENTER = 0;
    private List<Column> columns = new ArrayList<Column>();
    private Column currentColumn;

    public static void main(String[] args) {
        new BnColumnBuilder().addColumn().withPath("this.name").withName("Name").addColumn().withPath("this.phone").withName("Phone").withWidth(100).withWidthFixed(true).build();
    }

    public BnColumnBuilder addColumn() {
        this.currentColumn = new Column();
        this.columns.add(this.currentColumn);
        return this;
    }

    public BnColumnBuilder withPath(String pathStr) {
        this.checkCurrentColumn();
        this.currentColumn.path = Path.parse((String)pathStr);
        return this;
    }

    public BnColumnBuilder withName(String name) {
        this.checkCurrentColumn();
        this.currentColumn.columnName = name;
        return this;
    }

    public BnColumnBuilder withWidth(int width) {
        this.checkCurrentColumn();
        this.currentColumn.width = width;
        return this;
    }

    public BnColumnBuilder withWidthFixed(boolean fixed) {
        this.checkCurrentColumn();
        this.currentColumn.fixed = fixed;
        return this;
    }

    public BnColumnBuilder withOperationPath(String pathStr) {
        this.checkCurrentColumn();
        this.currentColumn.operationPath = Path.parse((String)pathStr);
        return this;
    }

    public BnColumnBuilder withAlignment(Integer alignment) {
        this.checkCurrentColumn();
        this.currentColumn.alignment = alignment;
        return this;
    }

    public BnColumn[] build() {
        BnColumn[] result = new BnColumn[this.columns.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.columns.get(i).toBnColumn();
        }
        return result;
    }

    private void checkCurrentColumn() {
        if (this.currentColumn == null) {
            throw new IllegalStateException("No current column. Call 'addColumn' first.");
        }
    }

    private static class Column {
        private String columnName;
        private Path path;
        private int width = 100;
        private boolean fixed = false;
        private Path operationPath;
        private Integer alignment = BnColumn.DEFAULT_ALIGNEMNT;

        private Column() {
        }

        BnColumn toBnColumn() {
            return new BnColumn(this.path, this.columnName, this.width, this.fixed, this.operationPath, this.alignment);
        }
    }
}

