/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table;

import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.ElementsAddedEvent;
import org.beanfabrics.event.ElementsRemovedEvent;
import org.beanfabrics.event.ListAdapter;
import org.beanfabrics.event.ListListener;
import org.beanfabrics.event.WeakListAdapter;
import org.beanfabrics.log.Logger;
import org.beanfabrics.log.LoggerFactory;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.table.BnColumn;
import org.beanfabrics.swing.table.BnTableModel;
import org.beanfabrics.swing.table.BnTableRowSorter;
import org.beanfabrics.swing.table.BnTableSelectionModel;
import org.beanfabrics.swing.table.Java5SortingTableHeader;
import org.beanfabrics.swing.table.celleditor.BnTableCellEditor;
import org.beanfabrics.swing.table.cellrenderer.BnTableCellRenderer;

public class BnTable
extends JTable
implements View<IListPM<? extends PresentationModel>>,
ModelSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(BnTable.class);
    private final ListAdapter listListener = new MyWeakListAdapter();
    private final Link link = new Link((View)this);
    private IListPM<? extends PresentationModel> presentationModel;
    private List<BnColumn> columns = Collections.emptyList();
    private boolean cellEditingAllowed;
    private boolean sortable;
    private final AutoResizeExtension autoResizeExtension = this.createAutoResizeExtension();

    public BnTable() {
        this.setSurrendersFocusOnKeystroke(true);
        this.setAutoResizeMode(0);
        this.setCellEditingAllowed(true);
        this.setSortable(true);
    }

    public boolean isCellEditingAllowed() {
        return this.cellEditingAllowed;
    }

    public void setCellEditingAllowed(boolean newValue) {
        TableModel tblModel;
        boolean oldValue = this.cellEditingAllowed;
        this.cellEditingAllowed = newValue;
        if (this.isConnected() && (tblModel = this.getModel()) instanceof BnTableModel) {
            ((BnTableModel)tblModel).setCellEditingAllowed(this.cellEditingAllowed);
        }
        this.firePropertyChange("cellEditingAllowed", oldValue, newValue);
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean newValue) {
        boolean oldValue = this.sortable;
        if (oldValue == newValue) {
            return;
        }
        this.sortable = newValue;
        if (this.isConnected()) {
            this.disconnect();
            this.connect();
        }
        this.firePropertyChange("sortable", oldValue, newValue);
    }

    public IListPM<? extends PresentationModel> getPresentationModel() {
        return this.presentationModel;
    }

    public void setPresentationModel(IListPM<? extends PresentationModel> newModel) {
        IListPM<? extends PresentationModel> oldModel = this.presentationModel;
        if (newModel == oldModel) {
            return;
        }
        this.disconnect();
        this.presentationModel = newModel;
        this.connect();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    private boolean isConnected() {
        return this.columns != null && this.presentationModel != null;
    }

    protected void connect() {
        if (this.columns == null) {
            return;
        }
        if (this.presentationModel == null) {
            DefaultTableModel dummyModel = new DefaultTableModel();
            for (BnColumn col : this.columns) {
                dummyModel.addColumn(col.getColumnName());
            }
            this.setModel(dummyModel);
            return;
        }
        this.presentationModel.addListListener((ListListener)this.listListener);
        this.setModel(new BnTableModel(this.presentationModel, this.columns, this.cellEditingAllowed));
        if (this.isSortable()) {
            this.installSortingFeature();
        }
        int currentSelectionMode = this.getSelectionModel().getSelectionMode();
        BnTableSelectionModel newModel = new BnTableSelectionModel(this.presentationModel);
        newModel.setSelectionMode(currentSelectionMode);
        this.setSelectionModel(newModel);
        this.autoResizeExtension.resizeColumns();
    }

    private void installSortingFeature() {
        this.installRowSorter();
        JTableHeader header = this.getTableHeader();
        if (header instanceof Java5SortingTableHeader) {
            Java5SortingTableHeader headerJ5 = (Java5SortingTableHeader)header;
            headerJ5.setSortable(true);
        }
    }

    private void uninstallSortingFeature() {
        this.uninstallRowSorter();
        JTableHeader header = this.getTableHeader();
        if (header instanceof Java5SortingTableHeader) {
            Java5SortingTableHeader headerJ5 = (Java5SortingTableHeader)header;
            headerJ5.setSortable(false);
        }
    }

    private void installRowSorter() {
        ListSelectionModel oldSelModel = this.getSelectionModel();
        int oldSelectionMode = oldSelModel.getSelectionMode();
        this.setSelectionModel(this.createDefaultSelectionModel());
        this.setSelectionMode(oldSelectionMode);
        BnTableRowSorter.install(this);
        this.setSelectionModel(oldSelModel);
    }

    private void uninstallRowSorter() {
        BnTableRowSorter.uninstall(this);
    }

    @Override
    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        this.setDefaultRenderer(PresentationModel.class, new BnTableCellRenderer());
    }

    @Override
    protected void createDefaultEditors() {
        super.createDefaultEditors();
        this.setDefaultEditor(PresentationModel.class, new BnTableCellEditor());
    }

    protected void disconnect() {
        if (this.presentationModel != null) {
            this.presentationModel.removeListListener((ListListener)this.listListener);
        }
        ListSelectionModel selModel = this.getSelectionModel();
        int currentSelectionMode = selModel.getSelectionMode();
        if (selModel instanceof BnTableSelectionModel) {
            ((BnTableSelectionModel)selModel).dismiss();
        }
        this.setSelectionModel(this.createDefaultSelectionModel());
        this.getSelectionModel().setSelectionMode(currentSelectionMode);
        TableModel tblModel = this.getModel();
        if (tblModel instanceof BnTableModel) {
            ((BnTableModel)tblModel).dismiss();
        }
        this.setModel(this.createDefaultDataModel());
        this.uninstallSortingFeature();
    }

    public BnColumn[] getColumns() {
        return this.columns.toArray(new BnColumn[this.columns.size()]);
    }

    public void addColumn(BnColumn newCol) {
        if (this.columns != null) {
            ArrayList<BnColumn> list = new ArrayList<BnColumn>(this.columns);
            list.add(newCol);
            this.setColumns(list.toArray(new BnColumn[list.size()]));
        } else {
            this.setColumns(new BnColumn[]{newCol});
        }
    }

    public void setColumns(BnColumn[] newCols) {
        BnColumn[] old = null;
        if (this.columns != null) {
            old = this.columns.toArray(new BnColumn[this.columns.size()]);
            this.disconnect();
        }
        this.columns = Arrays.asList(newCols);
        this.connect();
        super.firePropertyChange("columns", old, newCols);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        super.columnMarginChanged(e);
        if (this.autoResizeExtension != null) {
            this.autoResizeExtension.columnMarginChanged(e);
        }
    }

    protected AutoResizeExtension createAutoResizeExtension() {
        return new AutoResizeExtension();
    }

    class AutoResizeExtension
    implements Serializable {
        private boolean pending_columnMarginChanged = false;

        AutoResizeExtension() {
            final ComponentAdapter parentComponentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    AutoResizeExtension.this.resizeColumns();
                }
            };
            BnTable.this.addHierarchyListener(new HierarchyListener(){
                private JViewport viewport;

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if (this.viewport != null) {
                        this.viewport.removeComponentListener(parentComponentListener);
                    }
                    this.viewport = AutoResizeExtension.this.getEnclosingViewport();
                    if (this.viewport != null) {
                        this.viewport.addComponentListener(parentComponentListener);
                    }
                }
            });
        }

        private boolean isEnabled() {
            return BnTable.this.getAutoResizeMode() == 0 && BnTable.this.columns != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void columnMarginChanged(ChangeEvent e) {
            if (this.pending_columnMarginChanged || !this.isEnabled()) {
                return;
            }
            this.pending_columnMarginChanged = true;
            try {
                int toviewindex = this.getResizingColumnViewIndex();
                for (int viewindex = 0; viewindex <= toviewindex; ++viewindex) {
                    int colIndex = BnTable.this.convertColumnIndexToModel(viewindex);
                    ((BnColumn)BnTable.this.columns.get(colIndex)).setWidth(BnTable.this.getColumnModel().getColumn(viewindex).getWidth());
                    ((BnColumn)BnTable.this.columns.get(colIndex)).setWidthFixed(true);
                }
                this.resizeColumns();
            }
            finally {
                this.pending_columnMarginChanged = false;
            }
        }

        int getResizingColumnViewIndex() {
            TableColumn resizingColumn;
            int result = -1;
            if (BnTable.this.tableHeader != null && (resizingColumn = BnTable.this.tableHeader.getResizingColumn()) != null) {
                result = BnTable.this.convertColumnIndexToView(resizingColumn.getModelIndex());
            }
            return result;
        }

        public void resizeColumns() {
            if (!this.isEnabled()) {
                return;
            }
            int totalWidth = this.getTotalWidth();
            if (totalWidth <= 0) {
                return;
            }
            int totalPreferredWith = this.getTotalPreferredWidth();
            int spaceLeft = totalWidth - totalPreferredWith;
            int additionalSpacePerColumn = 0;
            if (spaceLeft > 0 && BnTable.this.getColumnCount() - this.getColumnsWithFixedWidth() > 0) {
                additionalSpacePerColumn = spaceLeft / (BnTable.this.getColumnCount() - this.getColumnsWithFixedWidth());
            }
            int stillSpaceLeft = spaceLeft - additionalSpacePerColumn * (BnTable.this.getColumnCount() - this.getColumnsWithFixedWidth());
            for (int viewIndex = 0; viewIndex < BnTable.this.getColumnCount(); ++viewIndex) {
                BnColumn colAtIndex;
                TableColumn col = BnTable.this.getColumnModel().getColumn(viewIndex);
                int modelIndex = col.getModelIndex();
                int delta = 0;
                if (viewIndex == BnTable.this.getColumnCount() - 1 && stillSpaceLeft > 0) {
                    delta = stillSpaceLeft;
                }
                if (!(colAtIndex = (BnColumn)BnTable.this.columns.get(modelIndex)).isWidthFixed()) {
                    int newWidth = colAtIndex.getWidth() + additionalSpacePerColumn + delta;
                    this.setColumnWidth(viewIndex, newWidth);
                    continue;
                }
                int prefWidth = colAtIndex.getWidth() + delta;
                this.setColumnWidth(viewIndex, prefWidth);
            }
        }

        int getTotalWidth() {
            Container parent = BnTable.this.getParent();
            if (parent == null || !(parent instanceof JViewport)) {
                return -1;
            }
            int result = ((JViewport)parent).getSize().width;
            return result;
        }

        int getColumnsWithFixedWidth() {
            int count = 0;
            for (BnColumn col : BnTable.this.columns) {
                if (!col.isWidthFixed()) continue;
                ++count;
            }
            return count;
        }

        int getTotalPreferredWidth() {
            int sum = 0;
            for (BnColumn col : BnTable.this.columns) {
                sum += col.getWidth();
            }
            return sum;
        }

        void setColumnWidth(int columnViewIndex, int width) {
            TableColumn col = BnTable.this.getColumnModel().getColumn(columnViewIndex);
            int minw = col.getMinWidth();
            int maxw = col.getMaxWidth();
            if (col.getWidth() == width) {
                return;
            }
            col.setMinWidth(width);
            col.setMaxWidth(width);
            col.setWidth(width);
            if (minw > width) {
                col.setMinWidth(width);
            } else {
                col.setMinWidth(minw);
            }
            col.setMaxWidth(maxw);
        }

        JViewport getEnclosingViewport() {
            Container gp;
            Container p = BnTable.this.getParent();
            if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)gp;
                JViewport viewport = scrollPane.getViewport();
                if (viewport == null || viewport.getView() != BnTable.this) {
                    return null;
                }
                return viewport;
            }
            return null;
        }
    }

    private class MyWeakListAdapter
    extends WeakListAdapter
    implements Serializable {
        private MyWeakListAdapter() {
        }

        public void elementsAdded(ElementsAddedEvent evt) {
            this.cancelCellEditing();
        }

        public void elementsRemoved(ElementsRemovedEvent evt) {
            this.cancelCellEditing();
        }

        private void cancelCellEditing() {
            if (BnTable.this.getCellEditor() != null) {
                BnTable.this.getCellEditor().cancelCellEditing();
            }
        }
    }
}

