/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table.celleditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.swing.BnComboBox;

public class BnComboBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final ActionListener stopAction = new StopActionListener();
    private final PopupMenuListener popupListener = new MyPopupMenuListener();
    private transient WeakReference<BnComboBox> cacheEntry = new WeakReference<Object>(null);

    private BnComboBox createBnComboBox() {
        BnComboBox comboBox = new BnComboBox();
        comboBox.addPopupMenuListener(this.popupListener);
        comboBox.registerKeyboardAction(this.stopAction, KeyStroke.getKeyStroke(10, 0), 0);
        return comboBox;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ITextPM pm;
        if (value instanceof ITextPM && (pm = (ITextPM)value).getOptions() != null) {
            BnComboBox comboBox = (BnComboBox)this.cacheEntry.get();
            if (comboBox == null || comboBox.getPresentationModel() != pm) {
                comboBox = this.createBnComboBox();
                comboBox.setPresentationModel((ITextPM)value);
                this.cacheEntry = new WeakReference<BnComboBox>(comboBox);
            }
            return comboBox;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        this.clearCacheEntry();
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.clearCacheEntry();
        super.cancelCellEditing();
    }

    private void clearCacheEntry() {
        this.cacheEntry = new WeakReference<Object>(null);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.cacheEntry = new WeakReference<Object>(null);
    }

    private class MyPopupMenuListener
    implements PopupMenuListener {
        private MyPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            BnComboBoxCellEditor.this.fireEditingStopped();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            BnComboBoxCellEditor.this.fireEditingCanceled();
        }
    }

    private class StopActionListener
    implements ActionListener,
    Serializable {
        private StopActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BnComboBoxCellEditor.this.fireEditingStopped();
        }
    }
}

