/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table.celleditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.Path;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.BnButton;
import org.beanfabrics.swing.KeyBindingProcessor;
import org.beanfabrics.swing.table.BnColumn;
import org.beanfabrics.swing.table.BnTable;
import org.beanfabrics.swing.table.celleditor.BnCheckBoxCellEditor;
import org.beanfabrics.swing.table.celleditor.BnComboBoxCellEditor;
import org.beanfabrics.swing.table.celleditor.BnTextFieldCellEditor;
import org.beanfabrics.swing.table.celleditor.EmptyCellEditor;

public class BnTableCellEditor
implements TableCellEditor {
    private final EmptyCellEditor FALLBACK_EDITOR = new EmptyCellEditor();
    private int clickCountToStart = 1;
    private JComponent currentComponent;
    private TableCellEditor currentCellEditor;
    private final List<TableCellEditor> installedEditors = new ArrayList<TableCellEditor>();

    public BnTableCellEditor() {
        this.installDefaultEditors();
    }

    private void installDefaultEditors() {
        this.installedEditors.add(new BnCheckBoxCellEditor());
        this.installedEditors.add(new BnComboBoxCellEditor());
        this.installedEditors.add(new BnTextFieldCellEditor());
    }

    public List<TableCellEditor> getInstalledEditors() {
        return this.installedEditors;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        BnColumn bnCol;
        JComponent result = null;
        TableCellEditor editor = null;
        for (TableCellEditor aEd : this.installedEditors) {
            Component aComp = aEd.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (aComp == null || !(aComp instanceof JComponent)) continue;
            result = (JComponent)aComp;
            editor = aEd;
            break;
        }
        if (editor == null) {
            editor = this.FALLBACK_EDITOR;
            result = (JComponent)this.FALLBACK_EDITOR.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        if ((bnCol = this.getBnColumn(table, column)).getOperationPath() != null) {
            result = this.createButtonDecorator(table, row, result, bnCol);
        }
        this.setCurrentComponent(result);
        this.setCurrentCellEditor(editor);
        return result;
    }

    protected JComponent createButtonDecorator(JTable table, int row, JComponent leftComponent, BnColumn bnCol) {
        PresentationModel rowModel = this.getRowModel(table, row);
        ButtonDecorator deco = new ButtonDecorator(leftComponent, rowModel, bnCol.getOperationPath());
        return deco;
    }

    protected PresentationModel getRowModel(JTable table, int row) {
        BnTable bnTable = (BnTable)table;
        PresentationModel result = bnTable.getPresentationModel().getAt(row);
        return result;
    }

    private BnColumn getBnColumn(JTable table, int column) {
        BnTable bnTable = (BnTable)table;
        BnColumn result = bnTable.getColumns()[column];
        return result;
    }

    public JComponent getCurrentComponent() {
        return this.currentComponent;
    }

    public void setCurrentComponent(JComponent currentComponent) {
        this.currentComponent = currentComponent;
    }

    public TableCellEditor getCurrentCellEditor() {
        return this.currentCellEditor;
    }

    public void setCurrentCellEditor(TableCellEditor currentCellEditor) {
        this.currentCellEditor = currentCellEditor;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.currentCellEditor.shouldSelectCell(anEvent);
    }

    @Override
    public void cancelCellEditing() {
        this.currentCellEditor.cancelCellEditing();
        this.setCurrentComponent(null);
        this.setCurrentCellEditor(null);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.currentCellEditor == null) {
            return true;
        }
        boolean result = this.currentCellEditor.stopCellEditing();
        this.setCurrentComponent(null);
        this.setCurrentCellEditor(null);
        return result;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.currentCellEditor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.currentCellEditor.removeCellEditorListener(l);
    }

    private static class ButtonDecorator
    extends JPanel {
        private ModelProvider modelProvider = new ModelProvider();
        private JComponent leftComponent;
        private BnButton button = new BnButton();

        public ButtonDecorator(JComponent leftComponent, PresentationModel rootModel, Path operationPath) {
            this.leftComponent = leftComponent;
            this.setLayout(new BorderLayout(0, 0));
            this.button.setMargin(new Insets(2, 2, 2, 2));
            this.button.setText("...");
            this.button.setFocusable(false);
            this.button.setPreferredSize(new Dimension(20, 0));
            this.button.setModelProvider((IModelProvider)this.modelProvider);
            this.button.setPath(operationPath);
            if (leftComponent != null) {
                this.add((Component)leftComponent, "Center");
            }
            this.add((Component)this.button, "East");
            this.setOpaque(false);
            this.modelProvider.setPresentationModel(rootModel);
        }

        public void dismiss() {
            this.modelProvider.setPresentationModel(null);
        }

        @Override
        public void requestFocus() {
            this.leftComponent.requestFocus();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            boolean result = super.processKeyBinding(ks, e, condition, pressed);
            if (!result && this.leftComponent instanceof KeyBindingProcessor) {
                ((KeyBindingProcessor)((Object)this.leftComponent)).processKeyBinding(ks, e, condition, pressed);
            }
            return result;
        }
    }
}

