/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table.celleditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.swing.BnTextField;

public class BnTextFieldCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final ActionListener stopAction = new StopActionListener();
    private transient WeakReference<BnTextField> cacheEntry = new WeakReference<Object>(null);

    private BnTextField createBnTextField() {
        BnTextField textField = new BnTextField();
        textField.setSelectAllOnFocusGainedEnabled(false);
        textField.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        textField.addActionListener(this.stopAction);
        return textField;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof ITextPM) {
            ITextPM pm = (ITextPM)value;
            BnTextField textField = (BnTextField)this.cacheEntry.get();
            if (textField == null || textField.getPresentationModel() != pm) {
                textField = this.createBnTextField();
                textField.setPresentationModel(pm);
                textField.setSelectAllOnFocusGainedEnabled(!isSelected);
                textField.selectAll();
                this.cacheEntry = new WeakReference<BnTextField>(textField);
            }
            return textField;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        this.clearCacheEntry();
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.clearCacheEntry();
        super.cancelCellEditing();
    }

    private void clearCacheEntry() {
        this.cacheEntry = new WeakReference<Object>(null);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.cacheEntry = new WeakReference<Object>(null);
    }

    private class StopActionListener
    implements ActionListener,
    Serializable {
        private StopActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BnTextFieldCellEditor.this.fireEditingStopped();
        }
    }
}

