/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table.celleditor;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.beanfabrics.model.ITextPM;

public class EmptyCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private transient WeakReference<JLabel> cacheEntry = new WeakReference<Object>(null);

    private JLabel createJLabel() {
        JLabel result = new JLabel();
        result.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        return result;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof ITextPM) {
            ITextPM pm = (ITextPM)value;
            JLabel label = (JLabel)this.cacheEntry.get();
            if (label == null) {
                label = this.createJLabel();
                this.cacheEntry = new WeakReference<JLabel>(label);
            }
            return label;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        this.clearCacheEntry();
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.clearCacheEntry();
        super.cancelCellEditing();
    }

    private void clearCacheEntry() {
        this.cacheEntry = new WeakReference<Object>(null);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.cacheEntry = new WeakReference<Object>(null);
    }
}

