/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table.cellrenderer;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.beanfabrics.model.IIconPM;
import org.beanfabrics.swing.ErrorIconPainter;
import org.beanfabrics.swing.table.BnColumn;
import org.beanfabrics.swing.table.BnTable;

public class IconPMTableCellRenderer
extends DefaultTableCellRenderer {
    private IIconPM model;
    private BnColumn column;
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();

    public IconPMTableCellRenderer() {
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof IIconPM) {
            this.column = this.getBnColumn(table, column);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        return null;
    }

    private BnColumn getBnColumn(JTable table, int columnIndex) {
        if (table instanceof BnTable) {
            BnTable bnTable = (BnTable)table;
            return bnTable.getColumns()[bnTable.convertColumnIndexToModel(columnIndex)];
        }
        return null;
    }

    @Override
    protected void setValue(Object value) {
        if (value != null && value instanceof IIconPM) {
            this.model = (IIconPM)value;
            this.setIcon(this.model.getIcon());
            this.setToolTipText(!this.model.isValid() ? this.model.getValidationState().getMessage() : this.model.getDescription());
            if (this.column != null && this.column.getAlignment() != null) {
                this.setHorizontalAlignment(this.column.getAlignment());
            }
        } else {
            this.model = null;
            this.setIcon(null);
            this.setToolTipText(null);
            this.setHorizontalAlignment(0);
        }
        this.setInheritsPopupMenu(true);
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        result.setHorizontalAlignment(this.invertHorizontalAlignment(this.getHorizontalAlignment()));
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        if (this.model == null) {
            return false;
        }
        return !this.model.isValid();
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        super.setHorizontalAlignment(alignment);
        if (this.errorIconPainter != null) {
            this.errorIconPainter.setHorizontalAlignment(this.invertHorizontalAlignment(alignment));
        }
    }

    private int invertHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 2: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 10;
            }
        }
        return alignment;
    }
}

