/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table.cellrenderer;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.beanfabrics.model.IIconPM;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.swing.ErrorIconPainter;
import org.beanfabrics.swing.table.BnColumn;
import org.beanfabrics.swing.table.BnTable;

public class TextPMTableCellRenderer
extends DefaultTableCellRenderer {
    private ITextPM model;
    private BnColumn column;
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof ITextPM) {
            this.column = this.getBnColumn(table, column);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        return null;
    }

    private BnColumn getBnColumn(JTable table, int columnIndex) {
        if (table instanceof BnTable) {
            BnTable bnTable = (BnTable)table;
            return bnTable.getColumns()[bnTable.convertColumnIndexToModel(columnIndex)];
        }
        return null;
    }

    @Override
    protected void setValue(Object value) {
        this.model = (ITextPM)value;
        if (this.model != null) {
            this.setText(this.model.getText());
            this.setToolTipText(!this.model.isValid() ? this.model.getValidationState().getMessage() : this.model.getDescription());
            if (this.model instanceof IIconPM) {
                IIconPM iconCell = (IIconPM)this.model;
                this.setIcon(iconCell.getIcon());
            } else {
                this.setIcon(null);
            }
            if (this.column != null) {
                if (this.column.getAlignment() != null) {
                    this.setHorizontalAlignment(this.column.getAlignment());
                } else {
                    this.setHorizontalAlignment(10);
                }
            }
        } else {
            this.setText("");
            this.setToolTipText(null);
            this.setHorizontalAlignment(10);
            if (this.getIcon() != null) {
                this.setIcon(null);
            }
        }
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        result.setHorizontalAlignment(this.invertHorizontalAlignment(this.getHorizontalAlignment()));
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        if (this.model == null) {
            return false;
        }
        return !this.model.isValid();
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        super.setHorizontalAlignment(alignment);
        if (this.errorIconPainter != null) {
            this.errorIconPainter.setHorizontalAlignment(this.invertHorizontalAlignment(alignment));
        }
    }

    private int invertHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 2: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 10;
            }
        }
        return alignment;
    }
}

