/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.datasync;

import jakarta.servlet.http.HttpSession;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.datasync.AbstractPerXStoreProvider;
import org.directwebremoting.datasync.StoreProvider;
import org.directwebremoting.datasync.StoreProviderFactory;

public class PerHttpSessionStoreProvider<T>
extends AbstractPerXStoreProvider<T> {
    private final String attributeName;
    private final StoreProviderFactory<T, HttpSession> factory;

    public PerHttpSessionStoreProvider(StoreProviderFactory<T, HttpSession> factory, String attributeName) {
        this.factory = factory;
        this.attributeName = attributeName;
    }

    @Override
    protected StoreProvider<T> getStoreProvider() {
        HttpSession session = WebContextFactory.get().getSession(true);
        StoreProvider<T> storeProvider = (StoreProvider<T>)session.getAttribute(this.attributeName);
        if (storeProvider == null) {
            storeProvider = this.factory.create(session);
            session.setAttribute(this.attributeName, storeProvider);
        }
        return storeProvider;
    }
}

