/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.Batch;
import org.directwebremoting.extend.Handler;

public abstract class BaseDwrpHandler
implements Handler {
    private boolean crossDomainSessionSecurity = true;
    private boolean extendedCrossDomainSessionSecurity = true;
    private boolean allowGetButMakeForgeryEasier = false;
    private static final Log log = LogFactory.getLog(BaseDwrpHandler.class);

    protected void checkGetAllowed(Batch batch) {
        if (!this.allowGetButMakeForgeryEasier && batch.isGet()) {
            log.error((Object)"GET is disallowed because it makes request forgery easier. See allowGetButMakeForgeryEasier setting for more details.");
            throw new SecurityException("GET Disallowed");
        }
    }

    protected void checkNotCsrfAttack(HttpServletRequest request, Batch batch) {
        HttpSession sess;
        if (!this.crossDomainSessionSecurity) {
            return;
        }
        if (request.getCookies() == null) {
            return;
        }
        int dwrCookieCount = 0;
        int dwrCookieMatchCount = 0;
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals("DWRSESSIONID")) continue;
            ++dwrCookieCount;
            if (!cookie.getValue().equals(batch.getDwrSessionId())) continue;
            ++dwrCookieMatchCount;
        }
        if (dwrCookieCount > 0 && dwrCookieMatchCount == 0) {
            this.throwCsrfException();
        }
        if (dwrCookieCount > 1 && dwrCookieMatchCount != dwrCookieCount) {
            log.warn((Object)"Multiple DWRSESSIONID cookies with different values in request.");
        }
        if (!this.extendedCrossDomainSessionSecurity) {
            return;
        }
        if (dwrCookieCount == 0) {
            this.throwCsrfException();
        }
        if ((sess = request.getSession(false)) == null) {
            return;
        }
        String registeredDwrSessionId = this.updateRegisteredDwrSession(sess, batch);
        if (!registeredDwrSessionId.equals(batch.getDwrSessionId())) {
            this.throwCsrfException();
        }
    }

    private void throwCsrfException() throws SecurityException {
        log.error((Object)"A request has been denied as a potential CSRF attack. This security check is performed as DWR's crossDomainSessionSecurity setting is active. Read more in the DWR documentation.");
        throw new SecurityException("CSRF Security Error (see server log for details).");
    }

    protected void updateCsrfState(HttpServletRequest request, Batch batch) {
        if (!this.crossDomainSessionSecurity || !this.extendedCrossDomainSessionSecurity) {
            return;
        }
        if (request.getCookies() == null) {
            return;
        }
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            return;
        }
        this.updateRegisteredDwrSession(sess, batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateRegisteredDwrSession(HttpSession sess, Batch batch) {
        String registeredDwrSessionId = (String)sess.getAttribute("org.directwebremoting.DWRSESSIONID");
        if (registeredDwrSessionId == null) {
            BaseDwrpHandler baseDwrpHandler = this;
            synchronized (baseDwrpHandler) {
                registeredDwrSessionId = (String)sess.getAttribute("org.directwebremoting.DWRSESSIONID");
                if (registeredDwrSessionId == null) {
                    registeredDwrSessionId = batch.getDwrSessionId();
                    sess.setAttribute("org.directwebremoting.DWRSESSIONID", (Object)registeredDwrSessionId);
                }
            }
        }
        return registeredDwrSessionId;
    }

    public void setCrossDomainSessionSecurity(boolean crossDomainSessionSecurity) {
        this.crossDomainSessionSecurity = crossDomainSessionSecurity;
    }

    public void setExtendedCrossDomainSessionSecurity(boolean value) {
        this.extendedCrossDomainSessionSecurity = value;
    }

    public void setAllowGetButMakeForgeryEasier(boolean allowGetButMakeForgeryEasier) {
        this.allowGetButMakeForgeryEasier = allowGetButMakeForgeryEasier;
    }
}

