/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.BaseDwrpHandler;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.dwrp.Batch;
import org.directwebremoting.dwrp.HtmlScriptConduit;
import org.directwebremoting.dwrp.PartialResponse;
import org.directwebremoting.dwrp.PlainScriptConduit;
import org.directwebremoting.dwrp.PollBatch;
import org.directwebremoting.extend.Alarm;
import org.directwebremoting.extend.ContainerAbstraction;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.RealWebContext;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.ShutdownAlarm;
import org.directwebremoting.impl.TimedAlarm;
import org.directwebremoting.util.BrowserDetect;

public class BasePollHandler
extends BaseDwrpHandler {
    protected Container container;
    protected boolean jsonOutput = false;
    protected boolean activeReverseAjaxEnabled = false;
    protected int maxWaitAfterWrite = -1;
    private boolean streamingEnabled;
    protected PageNormalizer pageNormalizer;
    protected ServerLoadMonitor serverLoadMonitor = null;
    protected ConverterManager converterManager = null;
    protected ScriptSessionManager scriptSessionManager = null;
    protected ContainerAbstraction containerAbstraction = null;
    protected ScheduledThreadPoolExecutor executor;
    protected boolean plain;
    private static final Log log = LogFactory.getLog(BasePollHandler.class);

    public BasePollHandler(boolean plain) {
        this.plain = plain;
    }

    @Override
    public void handle(final HttpServletRequest request, HttpServletResponse response) throws IOException {
        Sleeper proxiedSleeper;
        boolean canWeHaveFullStreaming;
        PollBatch batch;
        if (this.containerAbstraction.handleResumedRequest(request)) {
            return;
        }
        try {
            batch = new PollBatch(request);
        }
        catch (Exception ex) {
            log.debug((Object)"Failed to parse request", (Throwable)ex);
            response.sendError(400, "Failed to parse request");
            return;
        }
        this.checkGetAllowed(batch);
        this.checkNotCsrfAttack(request, batch);
        String normalizedPage = this.pageNormalizer.normalizePage(batch.getPage());
        final RealScriptSession scriptSession = this.scriptSessionManager.getOrCreateScriptSession(batch.getScriptSessionId(), normalizedPage, request.getSession(false));
        RealWebContext webContext = (RealWebContext)WebContextFactory.get();
        webContext.initialize(normalizedPage, scriptSession);
        if (!this.activeReverseAjaxEnabled) {
            log.error((Object)"Polling and Comet are disabled. To enable them set the init-param activeReverseAjaxEnabled to true.");
            String script = EnginePrivate.getRemotePollCometDisabledScript(batch.getBatchId());
            this.sendErrorScript(response, batch, script);
            return;
        }
        scriptSession.confirmScripts(batch.getNextReverseAjaxIndex() - 1L);
        BaseScriptConduit conduit = this.createScriptConduit(response.getWriter(), batch);
        final Sleeper sleeper = this.containerAbstraction.createSleeper(request, response, scriptSession, conduit);
        this.container.initializeBean(sleeper);
        final ArrayList<Alarm> alarms = new ArrayList<Alarm>();
        boolean clientSupportsLongRequests = BrowserDetect.supportsComet(request);
        boolean clientSupportsStreamingUpdates = batch.getPartialResponse() != PartialResponse.NO;
        boolean configurationSaysFullStreaming = this.streamingEnabled || this.maxWaitAfterWrite == -1;
        boolean bl = canWeHaveFullStreaming = clientSupportsLongRequests && clientSupportsStreamingUpdates && configurationSaysFullStreaming;
        if (!canWeHaveFullStreaming) {
            final int earlyCloseTimeout = this.maxWaitAfterWrite == -1 ? 500 : this.maxWaitAfterWrite;
            proxiedSleeper = new Sleeper(){

                @Override
                public void enterSleep(String batchId, Runnable onClose, int disconnectedTime) throws IOException {
                    sleeper.enterSleep(batchId, onClose, disconnectedTime);
                }

                @Override
                public void wakeUpForData() {
                    BasePollHandler.this.executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            sleeper.wakeUpToClose();
                        }
                    }, (long)earlyCloseTimeout, TimeUnit.MILLISECONDS);
                    sleeper.wakeUpForData();
                }

                @Override
                public int wakeUpToClose() {
                    return sleeper.wakeUpToClose();
                }
            };
        } else {
            proxiedSleeper = sleeper;
        }
        alarms.add(new TimedAlarm(proxiedSleeper, this.serverLoadMonitor.getConnectedTime(), this.executor));
        alarms.add(new ShutdownAlarm(proxiedSleeper, this.serverLoadMonitor));
        scriptSession.setSleeper(proxiedSleeper);
        int disconnectedTime = this.serverLoadMonitor.getDisconnectedTime();
        Runnable onClose = new Runnable(){

            @Override
            public void run() {
                for (Alarm alarm : alarms) {
                    alarm.cancel();
                }
                scriptSession.clearSleeper(proxiedSleeper);
                BasePollHandler.this.updateCsrfState(request, batch);
            }
        };
        if (scriptSession.getScript(0L) != null) {
            proxiedSleeper.wakeUpForData();
        }
        proxiedSleeper.enterSleep(batch.getBatchId(), onClose, disconnectedTime);
    }

    private BaseScriptConduit createScriptConduit(PrintWriter out, PollBatch batch) throws IOException {
        BaseScriptConduit conduit = this.plain ? new PlainScriptConduit(out, batch.getInstanceId(), null) : new HtmlScriptConduit(out, batch.getInstanceId(), batch.getBatchId(), batch.getDocumentDomain());
        return conduit;
    }

    protected void sendErrorScript(HttpServletResponse response, Batch batch, String script) throws IOException {
        PrintWriter out = response.getWriter();
        if (this.plain) {
            response.setContentType("text/plain");
        } else {
            response.setContentType("text/html");
        }
        out.println("//#DWR-START#");
        out.println(EnginePrivate.remoteBeginWrapper(batch.getInstanceId(), !this.plain, null));
        out.println(script);
        out.println(EnginePrivate.remoteEndWrapper(batch.getInstanceId(), !this.plain));
        out.println("//#DWR-END#");
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public boolean isJsonOutput() {
        return this.jsonOutput;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }

    @Deprecated
    public void setPollAndCometEnabled(boolean pollAndCometEnabled) {
        this.activeReverseAjaxEnabled = pollAndCometEnabled;
    }

    public void setActiveReverseAjaxEnabled(boolean activeReverseAjaxEnabled) {
        this.activeReverseAjaxEnabled = activeReverseAjaxEnabled;
    }

    public void setMaxWaitAfterWrite(int maxWaitAfterWrite) {
        this.maxWaitAfterWrite = maxWaitAfterWrite;
    }

    public void setStreamingEnabled(boolean streamingEnabled) {
        this.streamingEnabled = streamingEnabled;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setServerLoadMonitor(ServerLoadMonitor serverLoadMonitor) {
        this.serverLoadMonitor = serverLoadMonitor;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setScriptSessionManager(ScriptSessionManager scriptSessionManager) {
        this.scriptSessionManager = scriptSessionManager;
    }

    public void setContainerAbstraction(ContainerAbstraction containerAbstraction) {
        this.containerAbstraction = containerAbstraction;
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
    }
}

