/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.directwebremoting.dwrp.Batch;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.ConvertUtil;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.util.LocalUtil;

public class CallBatch
extends Batch {
    private final List<InboundContext> inboundContexts = new ArrayList<InboundContext>();
    private final Calls calls = new Calls();
    private static final int maxCallsPerBatch = 1000;

    public CallBatch(HttpServletRequest request) throws ServerException {
        super(request);
        this.parseParameters();
    }

    private void parseParameters() {
        int callCount;
        String callStr = this.extractParameter("callCount", "throw");
        try {
            callCount = Integer.parseInt(callStr);
        }
        catch (NumberFormatException ex) {
            throw new SecurityException("Invalid Call Count");
        }
        if (callCount > 1000) {
            throw new SecurityException("Too many calls in a batch");
        }
        this.calls.setBatchId(this.getBatchId());
        this.calls.setInstanceId(this.getInstanceId());
        for (int callNum = 0; callNum < callCount; ++callNum) {
            InboundContext inboundContext = new InboundContext();
            this.inboundContexts.add(inboundContext);
            String prefix = "c" + callNum + "-";
            String callId = this.extractParameter(prefix + "id", "throw");
            if (!LocalUtil.isLetterOrDigitOrUnderline(callId)) {
                throw new SecurityException("Call IDs may only contain Java Identifiers");
            }
            String scriptName = this.extractParameter(prefix + "scriptName", "throw");
            if (!LocalUtil.isValidScriptName(scriptName)) {
                throw new SecurityException("Illegal script name.");
            }
            String methodName = this.extractParameter(prefix + "methodName", "throw");
            if (!LocalUtil.isLetterOrDigitOrUnderline(methodName)) {
                throw new SecurityException("Method names may only contain Java Identifiers");
            }
            Iterator<Map.Entry<String, FormField>> it = this.getExtraParameters().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, FormField> entry = it.next();
                String key = entry.getKey();
                if (!key.startsWith(prefix)) continue;
                FormField formField = entry.getValue();
                if (formField.isFile()) {
                    inboundContext.createInboundVariable(callNum, key, "file", formField);
                } else {
                    String[] split = ConvertUtil.splitInbound(formField.getString());
                    String value = split[1];
                    String type = split[0].replace('?', ':');
                    inboundContext.createInboundVariable(callNum, key, type, value);
                }
                it.remove();
            }
            Call call = new Call(callId, scriptName, methodName);
            this.calls.addCall(call);
        }
    }

    public List<InboundContext> getInboundContexts() {
        return this.inboundContexts;
    }

    public Calls getCalls() {
        return this.calls;
    }

    public String toString() {
        return "CallBatch[page=" + this.getPage() + ",scriptSessionId=" + this.getScriptSessionId() + "]";
    }
}

