/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Injector;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.guice.AbstractDwrModule;
import org.directwebremoting.guice.CustomInjectorServletContextListener;
import org.directwebremoting.guice.DwrGuiceServletContextListener;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.DwrScopes;
import org.directwebremoting.guice.util.ContextCloseHandlers;

public abstract class AbstractDwrGuiceServletContextListener
extends AbstractDwrModule
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(AbstractDwrGuiceServletContextListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        final ServletContext servletContext = servletContextEvent.getServletContext();
        DwrGuiceUtil.withServletContext(servletContext, new Runnable(){

            @Override
            public void run() {
                AbstractDwrGuiceServletContextListener.publishInjector(servletContext, AbstractDwrGuiceServletContextListener.this.createInjector());
            }
        });
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        DwrScopes.GLOBAL.closeAll(ContextCloseHandlers.newExceptionLoggingCloseableHandler(exceptions));
        for (Exception e : exceptions) {
            log.warn((Object)("During context destroy, closing GLOBAL-scoped Closeables: " + e), (Throwable)e);
        }
    }

    protected abstract Injector createInjector();

    @Override
    protected abstract void configure();

    protected final ServletContext getServletContext() {
        return DwrGuiceUtil.getServletContext();
    }

    protected static Injector getPublishedInjector(ServletContext servletContext) {
        Injector injector = (Injector)servletContext.getAttribute("org.directwebremoting.guice.Injector");
        if (injector == null) {
            throw new IllegalStateException("Cannot find Injector in servlet context. You need to register a concrete extension of either " + DwrGuiceServletContextListener.class.getName() + " or " + CustomInjectorServletContextListener.class.getName() + " as a servlet context listener in your web.xml.");
        }
        return injector;
    }

    protected static void publishInjector(ServletContext servletContext, Injector injector) {
        servletContext.setAttribute("org.directwebremoting.guice.Injector", (Object)injector);
    }
}

