/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.hibernate;

import jakarta.servlet.ServletContext;
import java.beans.PropertyDescriptor;
import org.directwebremoting.ConversionException;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.PropertyDescriptorProperty;
import org.directwebremoting.hibernate.H3SessionAjaxFilter;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class H3PropertyDescriptorProperty
extends PropertyDescriptorProperty {
    public H3PropertyDescriptorProperty(PropertyDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    public Object getValue(Object bean) throws ConversionException {
        if (!(bean instanceof HibernateProxy)) {
            return super.getValue(bean);
        }
        boolean initialized = Hibernate.isPropertyInitialized((Object)bean, (String)this.descriptor.getName());
        if (initialized) {
            Object reply = super.getValue(bean);
            initialized = Hibernate.isInitialized((Object)reply);
        }
        if (initialized) {
            return super.getValue(bean);
        }
        HibernateProxy proxy = (HibernateProxy)bean;
        LazyInitializer initializer = proxy.getHibernateLazyInitializer();
        SessionImplementor implementor = initializer.getSession();
        if (implementor.isOpen()) {
            return super.getValue(bean);
        }
        ServletContext context = WebContextFactory.get().getServletContext();
        Session session = H3SessionAjaxFilter.getCurrentSession(context);
        if (session != null) {
            session.update(bean);
            return super.getValue(bean);
        }
        return null;
    }
}

