/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.ServerContext;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.PageScriptSessionFilter;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.util.VersionUtil;

public class DefaultServerContext
implements ServerContext {
    private ServletConfig servletConfig = null;
    private ServletContext servletContext = null;
    private Container container = null;
    private ScriptSessionManager sessionManager = null;
    private ConverterManager converterManager = null;
    private static final Log log = LogFactory.getLog(DefaultServerContext.class);

    @Override
    public Collection<ScriptSession> getAllScriptSessions() {
        return this.getScriptSessionManager().getAllScriptSessions();
    }

    @Override
    public Collection<ScriptSession> getScriptSessionsByPage(String url) {
        ArrayList<ScriptSession> matching = new ArrayList<ScriptSession>();
        Collection<ScriptSession> allScriptSessions = this.getScriptSessionManager().getAllScriptSessions();
        PageScriptSessionFilter filter = new PageScriptSessionFilter(this, url);
        for (ScriptSession session : allScriptSessions) {
            if (!filter.match(session)) continue;
            matching.add(session);
        }
        return matching;
    }

    @Override
    public ScriptSession getScriptSessionById(String sessionId) {
        return this.getScriptSessionManager().getScriptSessionById(sessionId);
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public String getVersion() {
        return VersionUtil.getLabel();
    }

    @Override
    public String getContextPath() {
        UrlProcessor urlProcessor = this.container.getBean(UrlProcessor.class);
        return urlProcessor.getContextPath();
    }

    protected ScriptSessionManager getScriptSessionManager() {
        if (this.sessionManager == null) {
            this.sessionManager = this.container.getBean(ScriptSessionManager.class);
        }
        return this.sessionManager;
    }

    protected ConverterManager getConverterManager() {
        if (this.converterManager == null) {
            this.converterManager = this.container.getBean(ConverterManager.class);
        }
        return this.converterManager;
    }

    public String toString() {
        return "DefaultServerContext[path=" + this.servletConfig.getServletName() + ", container=" + this.container.getClass().getSimpleName() + "]";
    }

    public boolean equals(Object obj) {
        log.warn((Object)"Comparing ServerContexts is dangerous because DefaultWebContext inherits from DefaultServerContext. It is probably better to compare ServletContexts instead.");
        return super.equals(obj);
    }
}

