/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.StringWriter;
import org.directwebremoting.Container;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.RealWebContext;
import org.directwebremoting.impl.DefaultServerContext;
import org.directwebremoting.util.SwallowingHttpServletResponse;

public class DefaultWebContext
extends DefaultServerContext
implements RealWebContext {
    private RealScriptSession scriptSession;
    private String page;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    protected DefaultWebContext(Container container, HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig, ServletContext servletContext) {
        this.setServletConfig(servletConfig);
        this.setServletContext(servletContext);
        this.setContainer(container);
        this.request = request;
        this.response = response;
    }

    @Override
    public void initialize(String sentPage, RealScriptSession scriptSession) {
        this.scriptSession = scriptSession;
        this.page = sentPage;
    }

    @Override
    public String getCurrentPage() {
        if (this.page == null) {
            throw new UnsupportedOperationException("CurrentPage is not supported from a JSON call.");
        }
        return this.page;
    }

    @Override
    public ScriptSession getScriptSession() {
        return this.scriptSession;
    }

    @Override
    public HttpSession getSession() {
        return this.request.getSession();
    }

    @Override
    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    @Override
    public String forwardToString(String url) throws ServletException, IOException {
        StringWriter sout = new StringWriter();
        StringBuffer buffer = sout.getBuffer();
        HttpServletResponse realResponse = this.getHttpServletResponse();
        SwallowingHttpServletResponse fakeResponse = new SwallowingHttpServletResponse(realResponse, sout, realResponse.getCharacterEncoding());
        HttpServletRequest realRequest = this.getHttpServletRequest();
        realRequest.setAttribute("org.directwebremoting", (Object)Boolean.TRUE);
        this.getServletContext().getRequestDispatcher(url).include((ServletRequest)realRequest, (ServletResponse)fakeResponse);
        return buffer.toString();
    }

    private String simplifyId(String id) {
        if (id == null) {
            return "[null]";
        }
        if (id.length() == 0) {
            return "[blank]";
        }
        if (id.length() < 4) {
            return id;
        }
        return id.substring(0, 4);
    }

    @Override
    public String toString() {
        return "DefaultWebContext[id=" + this.simplifyId(this.scriptSession.getId()) + ", page=" + this.page + "]";
    }
}

