/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.IdGenerator;
import org.directwebremoting.io.FileTransfer;

public abstract class PurgingDownloadManager
implements DownloadManager {
    protected ScheduledThreadPoolExecutor executor = null;
    protected DownloadPurge downloadPurge = new DownloadPurge();
    protected int queueSleepTime = 15000;
    protected long purgeDownloadsAfter = 120000L;
    protected String downloadHandlerUrl;
    protected IdGenerator idGenerator;

    @Override
    public String addFileTransfer(FileTransfer generator) throws IOException {
        String id = this.idGenerator.generate();
        this.putFileTransfer(id, generator);
        HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
        return "'" + request.getContextPath() + request.getServletPath() + this.downloadHandlerUrl + id + "'";
    }

    public void setDownloadHandlerUrl(String downloadHandlerUrl) {
        this.downloadHandlerUrl = downloadHandlerUrl;
    }

    public void setPurgeDownloadsAfter(long purgeDownloadsAfter) {
        this.purgeDownloadsAfter = purgeDownloadsAfter;
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
        this.executor.scheduleWithFixedDelay(this.downloadPurge, this.queueSleepTime, this.queueSleepTime, TimeUnit.MILLISECONDS);
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    protected abstract void putFileTransfer(String var1, FileTransfer var2);

    protected abstract void purge();

    public class DownloadPurge
    implements Runnable {
        @Override
        public void run() {
            PurgingDownloadManager.this.purge();
        }
    }
}

