/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.jsonp;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.ModuleManager;
import org.directwebremoting.extend.ParameterProperty;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.jsonp.JsonpCallException;

public class JsonpCallHandler
implements Handler {
    protected ConverterManager converterManager = null;
    protected ModuleManager moduleManager = null;
    protected AccessControl accessControl = null;
    protected boolean jsonpEnabled = false;
    protected Remoter remoter = null;
    private static final Log log = LogFactory.getLog(JsonpCallHandler.class);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.jsonpEnabled) {
            log.warn((Object)"JSONP request denied. To enable JSONP mode add an init-param of jsonpEnabled=true to web.xml");
            throw new SecurityException("JSONP interface disabled");
        }
        response.setContentType("text/javascript; charset=utf-8");
        String callback = this.getCallback(request);
        PrintWriter out = response.getWriter();
        try {
            Calls calls = this.convertToCalls(request);
            Replies replies = this.remoter.execute(calls);
            for (int i = 0; i < replies.getReplyCount(); ++i) {
                Reply reply = replies.getReply(i);
                try {
                    if (reply.getThrowable() != null) {
                        Throwable ex = reply.getThrowable();
                        this.writeData(out, ex, callback);
                        log.warn((Object)("--Erroring: message[" + ex.toString() + ']'));
                        continue;
                    }
                    Object data = reply.getReply();
                    this.writeData(out, data, callback);
                    continue;
                }
                catch (Exception ex) {
                    this.writeData(out, ex, callback);
                    log.error((Object)("--ConversionException: message=" + ex.toString()));
                }
            }
        }
        catch (Exception ex) {
            this.writeData(out, ex, callback);
        }
    }

    public String getCallback(HttpServletRequest request) {
        return request.getParameter("callback");
    }

    public Calls convertToCalls(HttpServletRequest request) {
        InboundContext inboundContext = new InboundContext();
        String pathInfo = request.getPathInfo();
        String[] pathParts = pathInfo.split("/");
        if (pathParts.length < 4) {
            log.warn((Object)("pathInfo '" + pathInfo + "' contains " + pathParts.length + " parts. At least 4 are required."));
            throw new JsonpCallException("Bad JSON request. See logs for more details.");
        }
        if (pathParts.length > 4) {
            for (int i = 4; i < pathParts.length; ++i) {
                String key = "c0-param" + (i - 4);
                inboundContext.createInboundVariable(0, key, "string", pathParts[i]);
            }
        } else {
            String[] values;
            Map requestParams = request.getParameterMap();
            int i = 0;
            while ((values = (String[])requestParams.get("param" + i)) != null) {
                String key = "c0-param" + i;
                inboundContext.createInboundVariable(0, key, "string", values[0], true);
                ++i;
            }
        }
        Call call = new Call(null, pathParts[2], pathParts[3]);
        Calls calls = new Calls();
        calls.addCall(call);
        call.findMethod(this.moduleManager, this.converterManager, inboundContext, 0);
        MethodDeclaration method = call.getMethodDeclaration();
        this.accessControl.assertGeneralExecutionIsPossible(call.getScriptName(), method);
        try {
            inboundContext.dereference();
        }
        catch (ConversionException ex) {
            log.warn((Object)"Dereferencing exception", (Throwable)ex);
            throw new JsonpCallException("Error dereferencing call. See logs for more details.");
        }
        Object[] params = new Object[method.getParameterTypes().length];
        for (int j = 0; j < method.getParameterTypes().length; ++j) {
            Class<?> paramType = method.getParameterTypes()[j];
            InboundVariable param = inboundContext.getParameter(0, j);
            ParameterProperty property = new ParameterProperty(method, j);
            try {
                params[j] = this.converterManager.convertInbound(paramType, param, property);
                continue;
            }
            catch (ConversionException ex) {
                log.warn((Object)("Marshalling exception. Param " + j + ", "), (Throwable)ex);
                throw new JsonpCallException("Error marshalling parameters. See logs for more details.");
            }
        }
        call.setParameters(params);
        return calls;
    }

    public void writeData(PrintWriter out, Object data, String callback) {
        try {
            ScriptBuffer buffer = new ScriptBuffer();
            buffer.appendData(data);
            String output = ScriptBufferUtil.createOutput(buffer, this.converterManager, true);
            if (data instanceof Exception) {
                output = "{\"error\":" + output + "}";
            }
            if (callback != null && !"".equals(callback.trim())) {
                output = callback + "(" + output + ")";
            }
            out.println(output);
        }
        catch (ConversionException ex) {
            log.warn((Object)("--ConversionException: class=" + ex.getConversionType().getName()), (Throwable)ex);
            ScriptBuffer buffer = new ScriptBuffer();
            buffer.appendData(ex);
            try {
                String output = ScriptBufferUtil.createOutput(buffer, this.converterManager, true);
                output = "{\"error\":" + output + "}";
                if (callback != null && !"".equals(callback.trim())) {
                    output = callback + "(" + output + ")";
                }
                out.println(output);
            }
            catch (ConversionException ex1) {
                log.error((Object)("--Nested ConversionException: Is there an exception handler registered? class=" + ex.getConversionType().getName()), (Throwable)ex);
            }
        }
    }

    public boolean isConvertable(Class<?> paramType) {
        return this.converterManager.isConvertable(paramType);
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setJsonpEnabled(boolean jsonpEnabled) {
        this.jsonpEnabled = jsonpEnabled;
    }

    public void setRemoter(Remoter remoter) {
        this.remoter = remoter;
    }
}

