/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.jetty;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.directwebremoting.extend.ContainerAbstraction;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.DefaultServerLoadMonitor;
import org.directwebremoting.server.jetty.JettyContinuationSleeper;
import org.directwebremoting.util.LocalUtil;

public class JettyContinuationContainerAbstraction
implements ContainerAbstraction {
    @Override
    public boolean isNativeEnvironment(ServletConfig servletConfig) {
        try {
            LocalUtil.classForName("org.eclipse.jetty.continuation.ContinuationSupport");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    @Override
    public Class<? extends ServerLoadMonitor> getServerLoadMonitorImplementation() {
        return DefaultServerLoadMonitor.class;
    }

    @Override
    public boolean handleResumedRequest(HttpServletRequest request) {
        JettyContinuationSleeper sleeper = JettyContinuationSleeper.getSleeper(request);
        if (sleeper != null) {
            sleeper.resumeWork();
            return true;
        }
        return false;
    }

    @Override
    public Sleeper createSleeper(HttpServletRequest request, HttpServletResponse response, RealScriptSession scriptSession, ScriptConduit conduit) throws IOException {
        return new JettyContinuationSleeper(request, response, scriptSession, conduit);
    }
}

