/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.servlet3;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.directwebremoting.extend.ContainerAbstraction;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.DefaultServerLoadMonitor;
import org.directwebremoting.impl.ThreadWaitSleeper;
import org.directwebremoting.server.servlet3.Servlet30Sleeper;

public class Servlet30ContainerAbstraction
implements ContainerAbstraction {
    @Override
    public boolean isNativeEnvironment(ServletConfig servletConfig) {
        ServletContext ctx = servletConfig.getServletContext();
        return ctx.getMajorVersion() >= 3 && ctx.getEffectiveMajorVersion() >= 3;
    }

    @Override
    public Class<? extends ServerLoadMonitor> getServerLoadMonitorImplementation() {
        return DefaultServerLoadMonitor.class;
    }

    @Override
    public boolean handleResumedRequest(HttpServletRequest request) {
        return false;
    }

    @Override
    public Sleeper createSleeper(HttpServletRequest request, HttpServletResponse response, RealScriptSession scriptSession, ScriptConduit conduit) throws IOException {
        if (request.isAsyncSupported()) {
            return new Servlet30Sleeper(request, response, scriptSession, conduit);
        }
        return new ThreadWaitSleeper(response, scriptSession, conduit);
    }
}

