/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.servlet3;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.impl.BaseSleeper;

public class Servlet30Sleeper
extends BaseSleeper {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private AsyncContext asyncCtx = null;
    private final Object workLock = new Object();
    private boolean workInProgress = false;
    private boolean queuedWork = false;

    public Servlet30Sleeper(HttpServletRequest request, HttpServletResponse response, RealScriptSession scriptSession, ScriptConduit conduit) throws IOException {
        super(response, scriptSession, conduit);
        this.request = request;
        this.response = response;
        this.workInProgress = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void enterSleep() {
        this.asyncCtx = this.request.startAsync((ServletRequest)this.request, (ServletResponse)this.response);
        this.asyncCtx.setTimeout(-1L);
        Object object = this.workLock;
        synchronized (object) {
            if (this.queuedWork) {
                this.asyncCtx.start(new Runnable(){

                    @Override
                    public void run() {
                        Servlet30Sleeper.this.resumeWork();
                    }
                });
            } else {
                this.workInProgress = false;
            }
            this.queuedWork = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void wakeUp() {
        Object object = this.workLock;
        synchronized (object) {
            if (this.workInProgress) {
                this.queuedWork = true;
            } else {
                this.asyncCtx.start(new Runnable(){

                    @Override
                    public void run() {
                        Servlet30Sleeper.this.resumeWork();
                    }
                });
                this.workInProgress = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeWork() {
        while (true) {
            this.doWork();
            Object object = this.workLock;
            synchronized (object) {
                if (!this.queuedWork) {
                    this.workInProgress = false;
                    return;
                }
                this.queuedWork = false;
            }
        }
    }

    @Override
    protected void close() {
        if (this.asyncCtx != null) {
            this.asyncCtx.complete();
        }
    }
}

