/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.util.LocalUtil;

public abstract class CachingHandler
implements Handler {
    private String mimeType;
    private final Map<String, CachedResource> scriptCache = new HashMap<String, CachedResource>();
    private boolean ignoreLastModified = false;
    private static final Log log = LogFactory.getLog(CachingHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CachedResource resource;
        long lastModified = this.getLastModifiedTime();
        if (this.isUpToDate(request, lastModified)) {
            response.setStatus(304);
            return;
        }
        Map<String, CachedResource> map = this.scriptCache;
        synchronized (map) {
            String url = this.getCachingKey(request);
            resource = this.scriptCache.get(url);
            if (resource == null || lastModified > resource.lastModifiedTime) {
                if (log.isDebugEnabled()) {
                    if (resource == null) {
                        log.debug((Object)("Generating contents for " + url + ". It is not currently cached."));
                    } else {
                        log.debug((Object)("Generating contents for " + url + ". Resource modtime=" + lastModified + ". Cached modtime"));
                    }
                }
                resource = new CachedResource();
                resource.contents = this.generateCachableContent(request.getContextPath(), request.getServletPath(), request.getPathInfo());
                resource.lastModifiedTime = lastModified;
                this.scriptCache.put(url, resource);
            }
        }
        response.setContentType(this.mimeType);
        response.setDateHeader("Last-Modified", lastModified);
        response.setHeader("ETag", "\"" + lastModified + '\"');
        if (resource.contents != null) {
            PrintWriter out = response.getWriter();
            out.println(resource.contents);
        } else {
            response.sendError(404);
        }
    }

    protected abstract long getLastModifiedTime();

    public abstract String generateCachableContent(String var1, String var2, String var3) throws IOException;

    protected boolean isUpToDate(HttpServletRequest req, long lastModified) {
        String etag = "\"" + lastModified + '\"';
        if (this.ignoreLastModified) {
            return false;
        }
        long modifiedSince = -1L;
        try {
            modifiedSince = req.getDateHeader("If-Modified-Since");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        if (modifiedSince != -1L) {
            modifiedSince -= modifiedSince % 1000L;
        }
        String givenEtag = req.getHeader("If-None-Match");
        String cachedPath = this.getCachingKey(req);
        if (givenEtag == null) {
            if (modifiedSince >= lastModified) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending 304 for " + cachedPath + " If-Modified-Since=" + modifiedSince + ", Last-Modified=" + lastModified));
                }
                return true;
            }
            return false;
        }
        if (modifiedSince == -1L) {
            if (!etag.equals(givenEtag)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending 304 for " + cachedPath + ", If-Modified-Since=-1, Old ETag=" + givenEtag + ", New ETag=" + etag));
                }
                return true;
            }
            return false;
        }
        if (etag.equals(givenEtag) && modifiedSince >= lastModified) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending 304 for " + cachedPath + ", If-Modified-Since=" + modifiedSince + ", Last Modified=" + lastModified + ", Old ETag=" + givenEtag + ", New ETag=" + etag));
            }
            return true;
        }
        log.debug((Object)("Sending content for " + cachedPath + ", If-Modified-Since=" + modifiedSince + ", Last Modified=" + lastModified + ", Old ETag=" + givenEtag + ", New ETag=" + etag));
        return false;
    }

    protected String getCachingKey(HttpServletRequest request) {
        String absolutePath = LocalUtil.getFullUrlToDwrServlet(request);
        if (null != request.getPathInfo()) {
            absolutePath = absolutePath + request.getPathInfo();
        }
        return absolutePath;
    }

    public void setIgnoreLastModified(boolean ignoreLastModified) {
        this.ignoreLastModified = ignoreLastModified;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    class CachedResource {
        protected String contents;
        protected long lastModifiedTime;

        CachedResource() {
        }
    }
}

