/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.impl.StartupUtil;

public class DwrListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(DwrListener.class);

    public void contextInitialized(ServletContextEvent ev) {
    }

    public void contextDestroyed(ServletContextEvent ev) {
        List<Container> containers = StartupUtil.getAllPublishedContainers(ev.getServletContext());
        if (containers.isEmpty()) {
            log.debug((Object)"No containers to shutdown");
            return;
        }
        for (Container container : containers) {
            WebContextFactory.WebContextBuilder webContextBuilder = container.getBean(WebContextFactory.WebContextBuilder.class);
            if (webContextBuilder != null) {
                webContextBuilder.engageThread(container, null, null);
            }
            container.destroy();
            if (webContextBuilder == null) continue;
            webContextBuilder.disengageThread();
        }
    }
}

