/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;

public class DwrWebContextFilter
implements Filter {
    private static final Log log = LogFactory.getLog(DwrWebContextFilter.class);
    private FilterConfig filterConfig;

    public void init(FilterConfig newFilterConfig) throws ServletException {
        this.filterConfig = newFilterConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        WebContextFactory.WebContextBuilder webContextBuilder;
        ServletConfig servletConfig;
        ServletContext servletContext = this.filterConfig.getServletContext();
        Container container = (Container)servletContext.getAttribute(Container.class.getName());
        if (container == null) {
            log.error((Object)"DwrWebContextFilter can not find ServletContext attribute for the DWR Container. Is DwrServlet configured in this web-application?");
        }
        if ((servletConfig = (ServletConfig)servletContext.getAttribute(ServletConfig.class.getName())) == null) {
            log.error((Object)"DwrWebContextFilter can not find ServletContext attribute for the ServletConfig.");
        }
        if ((webContextBuilder = (WebContextFactory.WebContextBuilder)servletContext.getAttribute(WebContextFactory.WebContextBuilder.class.getName())) == null) {
            log.error((Object)"DwrWebContextFilter can not find ServletContext attribute for the WebContextBuilder. WebContext will not be available.");
        } else {
            try {
                webContextBuilder.engageThread(container, (HttpServletRequest)request, (HttpServletResponse)response);
                chain.doFilter(request, response);
            }
            finally {
                webContextBuilder.disengageThread();
            }
        }
    }

    public void destroy() {
    }
}

