/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.servlet.ResponseHandler;
import org.directwebremoting.util.LocalUtil;

public class PublicPeriodCacheableResponse
implements ResponseHandler {
    private int periodCacheableSecs = -1;
    private boolean debug = false;

    @Override
    public void handle(Handler handler, HttpServletRequest request, HttpServletResponse response) {
        if (this.periodCacheableSecs == 0) {
            LocalUtil.addNoCacheHeaders(response);
            return;
        }
        int cacheSecs = this.periodCacheableSecs < 0 ? (this.debug ? 60 : 300) : this.periodCacheableSecs;
        long expiry = new Date().getTime() + (long)(cacheSecs * 1000);
        response.setHeader("Cache-Control", "public, max-age=" + cacheSecs);
        response.setDateHeader("Expires", expiry);
    }

    public void setPeriodCacheableTime(int secs) {
        this.periodCacheableSecs = secs;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

