/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import jakarta.servlet.http.HttpServlet;
import org.directwebremoting.util.LoggingOutput;

public class ServletLoggingOutput
implements LoggingOutput {
    private static final ThreadLocal<HttpServlet> servlets = new ThreadLocal();
    private static int level = 3;

    public ServletLoggingOutput(Class<?> base) {
    }

    @Override
    public void debug(String message) {
        ServletLoggingOutput.log(1, message, null);
    }

    @Override
    public void info(String message) {
        ServletLoggingOutput.log(2, message, null);
    }

    @Override
    public void warn(String message) {
        ServletLoggingOutput.log(3, message, null);
    }

    @Override
    public void warn(String message, Throwable th) {
        ServletLoggingOutput.log(3, message, th);
    }

    @Override
    public void error(String message) {
        ServletLoggingOutput.log(4, message, null);
    }

    @Override
    public void error(String message, Throwable th) {
        ServletLoggingOutput.log(4, message, th);
    }

    @Override
    public void fatal(String message) {
        ServletLoggingOutput.log(5, message, null);
    }

    @Override
    public void fatal(String message, Throwable th) {
        ServletLoggingOutput.log(5, message, th);
    }

    private static void log(int loglevel, String message, Throwable th) {
        if (loglevel >= level) {
            HttpServlet servlet = servlets.get();
            if (servlet != null) {
                if (th == null) {
                    servlet.log(message);
                } else {
                    servlet.log(message, th);
                }
            } else {
                if (message != null) {
                    System.out.println(message);
                }
                if (th != null) {
                    th.printStackTrace();
                }
            }
        }
    }

    public static void setExecutionContext(HttpServlet servlet) {
        servlets.set(servlet);
    }

    public static void unsetExecutionContext() {
        servlets.set(null);
    }

    public static void setLevel(String logLevel) {
        if ("FATAL".equalsIgnoreCase(logLevel)) {
            ServletLoggingOutput.setLevel(5);
        } else if ("ERROR".equalsIgnoreCase(logLevel)) {
            ServletLoggingOutput.setLevel(4);
        } else if ("WARN".equalsIgnoreCase(logLevel)) {
            ServletLoggingOutput.setLevel(3);
        } else if ("INFO".equalsIgnoreCase(logLevel)) {
            ServletLoggingOutput.setLevel(2);
        } else if ("DEBUG".equalsIgnoreCase(logLevel)) {
            ServletLoggingOutput.setLevel(1);
        } else {
            throw new IllegalArgumentException("Unknown log level: " + logLevel);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return level == 1;
    }

    public static void setLevel(int level) {
        ServletLoggingOutput.level = level;
    }

    public static int getLevel() {
        return level;
    }
}

