/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.webwork;

import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.util.OgnlValueStack;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.FakeHttpServletResponse;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.webwork.ActionDefinition;
import org.directwebremoting.webwork.AjaxResult;
import org.directwebremoting.webwork.AjaxTextResult;
import org.directwebremoting.webwork.DefaultAjaxDataResult;
import org.directwebremoting.webwork.DefaultAjaxTextResult;
import org.directwebremoting.webwork.IDWRActionProcessor;

public class DWRAction {
    private static final Log log = LogFactory.getLog(DWRAction.class);
    private static final String DWRACTIONPROCESSOR_INIT_PARAM = "dwrActionProcessor";
    private static DWRAction instance;
    private DispatcherUtils wwDispatcher;
    private IDWRActionProcessor actionProcessor;

    private DWRAction(ServletContext servletContext) throws ServletException {
        DispatcherUtils.initialize((ServletContext)servletContext);
        this.wwDispatcher = DispatcherUtils.getInstance();
        this.actionProcessor = DWRAction.loadActionProcessor(servletContext.getInitParameter(DWRACTIONPROCESSOR_INIT_PARAM));
    }

    protected AjaxResult doExecute(ActionDefinition actionDefinition, Map<String, String> params, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException {
        FakeHttpServletResponse actionResponse = new FakeHttpServletResponse();
        if (null != this.actionProcessor) {
            this.actionProcessor.preProcess(request, response, actionResponse, params);
        }
        this.wwDispatcher.prepare(request, (HttpServletResponse)actionResponse);
        ActionInvocation invocation = this.invokeAction(this.wwDispatcher, request, actionResponse, servletContext, actionDefinition, params);
        AjaxResult result = actionDefinition.isExecuteResult() ? this.getTextResult(actionResponse) : new DefaultAjaxDataResult(invocation.getAction());
        if (null != this.actionProcessor) {
            this.actionProcessor.postProcess(request, response, actionResponse, result);
        }
        return result;
    }

    protected ActionInvocation invokeAction(DispatcherUtils du, HttpServletRequest request, HttpServletResponse response, ServletContext context, ActionDefinition actionDefinition, Map<String, String> params) throws ServletException {
        ActionMapping mapping = this.getActionMapping(actionDefinition, params);
        Map extraContext = du.createContextMap(request, response, mapping, context);
        OgnlValueStack stack = (OgnlValueStack)request.getAttribute("webwork.valueStack");
        if (null != stack) {
            extraContext.put("com.opensymphony.xwork.util.OgnlValueStack.ValueStack", new OgnlValueStack(stack));
        }
        try {
            this.prepareContinuationAction(request, extraContext);
            ActionProxy proxy = ActionProxyFactory.getFactory().createActionProxy(actionDefinition.getNamespace(), actionDefinition.getAction(), extraContext, actionDefinition.isExecuteResult(), false);
            proxy.setMethod(actionDefinition.getMethod());
            request.setAttribute("webwork.valueStack", (Object)proxy.getInvocation().getStack());
            if (mapping.getResult() != null) {
                Result result = mapping.getResult();
                result.execute(proxy.getInvocation());
            } else {
                proxy.execute();
            }
            ActionInvocation actionInvocation = proxy.getInvocation();
            return actionInvocation;
        }
        catch (ConfigurationException ce) {
            throw new ServletException("Cannot invoke action '" + actionDefinition.getAction() + "' in namespace '" + actionDefinition.getNamespace() + "'", (Throwable)ce);
        }
        catch (Exception e) {
            throw new ServletException("Cannot invoke action '" + actionDefinition.getAction() + "' in namespace '" + actionDefinition.getNamespace() + "'", (Throwable)e);
        }
        finally {
            if (null != stack) {
                request.setAttribute("webwork.valueStack", (Object)stack);
            }
        }
    }

    protected void prepareContinuationAction(HttpServletRequest request, Map<String, Object> extraContext) {
        String id = request.getParameter("__continue");
        if (null != id) {
            Map params = (Map)extraContext.get("com.opensymphony.xwork.ActionContext.parameters");
            params.remove("__continue");
            extraContext.put("__continue", id);
        }
    }

    protected ActionMapping getActionMapping(ActionDefinition actionDefinition, Map<String, String> params) {
        ActionMapping actionMapping = new ActionMapping(actionDefinition.getAction(), actionDefinition.getNamespace(), actionDefinition.getMethod(), params);
        return actionMapping;
    }

    protected AjaxTextResult getTextResult(FakeHttpServletResponse response) {
        DefaultAjaxTextResult result = new DefaultAjaxTextResult();
        String text = null;
        try {
            text = response.getContentAsString();
        }
        catch (UnsupportedEncodingException uee) {
            log.warn((Object)"Cannot retrieve text output as string", (Throwable)uee);
        }
        if (null == text) {
            try {
                text = response.getCharacterEncoding() != null ? new String(response.getContentAsByteArray(), response.getCharacterEncoding()) : new String(response.getContentAsByteArray());
            }
            catch (UnsupportedEncodingException uee) {
                log.warn((Object)"Cannot retrieve text output as encoded byte array", (Throwable)uee);
                text = new String(response.getContentAsByteArray());
            }
        }
        result.setText(text);
        return result;
    }

    public static AjaxResult execute(ActionDefinition actionDefinition, Map<String, String> params, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException {
        DWRAction.initialize(servletContext);
        return instance.doExecute(actionDefinition, params, request, response, servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(ServletContext servletContext) throws ServletException {
        Class<DWRAction> clazz = DWRAction.class;
        synchronized (DWRAction.class) {
            if (null == instance) {
                instance = new DWRAction(servletContext);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static IDWRActionProcessor loadActionProcessor(String actionProcessorClassName) throws ServletException {
        if (null == actionProcessorClassName || "".equals(actionProcessorClassName)) {
            return null;
        }
        IDWRActionProcessor reply = LocalUtil.classNewInstance("DWRActionProcessor", actionProcessorClassName, IDWRActionProcessor.class);
        if (reply == null) {
            throw new ServletException("Cannot load DWRActionProcessor class '" + actionProcessorClassName + "'");
        }
        return reply;
    }
}

