/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwcli;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import org.bedework.bwcli.AccessLogs;
import org.bedework.bwcli.JolokiaConfigClient;
import org.bedework.bwcli.JsonMapper;
import org.bedework.bwcli.LogAnalysis;
import org.bedework.bwcli.bwcmd.CmdAdminGroups;
import org.bedework.bwcli.bwcmd.HttpClient;
import org.bedework.bwcli.copiedCalFacade.responses.AdminGroupsResponse;
import org.bedework.bwcli.jmxcmd.CmdCalSchema;
import org.bedework.bwcli.jmxcmd.CmdCardSchema;
import org.bedework.bwcli.jmxcmd.CmdEventregSchema;
import org.bedework.bwcli.jmxcmd.CmdIdxStats;
import org.bedework.bwcli.jmxcmd.CmdJmxSetAttr;
import org.bedework.bwcli.jmxcmd.CmdListIdx;
import org.bedework.bwcli.jmxcmd.CmdMakeIdxProd;
import org.bedework.bwcli.jmxcmd.CmdNewidx;
import org.bedework.bwcli.jmxcmd.CmdNotifierSchema;
import org.bedework.bwcli.jmxcmd.CmdPurgeIdx;
import org.bedework.bwcli.jmxcmd.CmdRebuildIdx;
import org.bedework.bwcli.jmxcmd.CmdRebuildStatus;
import org.bedework.bwcli.jmxcmd.CmdReindex;
import org.bedework.bwcli.jmxcmd.CmdRestoreCalData;
import org.bedework.bwcli.jmxcmd.CmdSelfRegAdduser;
import org.bedework.bwcli.jmxcmd.CmdSelfregSchema;
import org.bedework.bwcli.jmxcmd.CmdSync;
import org.bedework.bwcli.jmxcmd.CmdSysStats;
import org.bedework.bwcli.jmxcmd.CmdTzGetAttr;
import org.bedework.bwcli.jmxcmd.CmdTzRefresh;
import org.bedework.bwcli.jmxcmd.CmdTzSetAttr;
import org.bedework.bwcli.jmxcmd.bwengine.CmdSystem;
import org.bedework.bwcli.toolcmd.ToolCmd;
import org.bedework.bwcli.toolcmd.ToolSource;
import org.bedework.bwcli.toolcmd.ToolUser;
import org.bedework.util.args.Args;
import org.bedework.util.jolokia.JolokiaCli;
import org.bedework.util.jolokia.JolokiaClient;

public class BwCli
extends JolokiaCli {
    private WebClient webClient;
    private final String url;
    private final String id;
    private final String pw;
    private AdminGroupsResponse adgrs;

    public BwCli(String url, String jmxUrl, String id, String pw, boolean debug) throws Throwable {
        super(jmxUrl, debug);
        this.url = url;
        this.id = id;
        this.pw = pw;
        this.register(new CmdAdminGroups());
        this.register(new CmdCalSchema());
        this.register(new CmdCardSchema());
        this.register(new CmdIdxStats());
        this.register(new CmdListIdx());
        this.register(new CmdMakeIdxProd());
        this.register(new CmdNewidx());
        this.register(new CmdNotifierSchema());
        this.register(new CmdPurgeIdx());
        this.register(new CmdRebuildIdx());
        this.register(new CmdRebuildStatus());
        this.register(new CmdReindex());
        this.register(new CmdRestoreCalData());
        this.register(new CmdSysStats());
        this.register(new CmdSync());
        this.register(new CmdTzGetAttr());
        this.register(new CmdTzSetAttr());
        this.register(new CmdTzRefresh());
        this.register(new CmdEventregSchema());
        this.register(new CmdSelfregSchema());
        this.register(new CmdSelfRegAdduser());
        this.register(new CmdSystem());
        this.register(new CmdJmxSetAttr());
        this.register(new ToolCmd());
        this.register(new ToolSource());
        this.register(new ToolUser());
    }

    public JolokiaClient makeClient(String uri) {
        return new JolokiaConfigClient(uri, this.id, this.pw);
    }

    public WebClient getWebClient() {
        if (this.webClient == null) {
            this.webClient = new WebClient(this.url);
        }
        return this.webClient;
    }

    public HttpClient getCl() {
        return this.getWebClient().getCl();
    }

    public void setAdgrs(AdminGroupsResponse val) {
        this.adgrs = val;
    }

    public AdminGroupsResponse getAdgrs() {
        return this.adgrs;
    }

    public static void main(String[] args) {
        String url = null;
        String id = null;
        String pw = null;
        String cmd = null;
        String cmdFile = null;
        String jmxUrl = null;
        boolean logShowLong = false;
        boolean logShowMissingTaskIds = false;
        boolean logSummariseTests = false;
        boolean debug = false;
        try {
            Args pargs = new Args(args);
            while (pargs.more()) {
                if (pargs.ifMatch("debug")) {
                    debug = true;
                    continue;
                }
                if (pargs.ifMatch("logshowlong")) {
                    logShowLong = true;
                    continue;
                }
                if (pargs.ifMatch("logshowmissingtaskids")) {
                    logShowMissingTaskIds = true;
                    continue;
                }
                if (pargs.ifMatch("logsummarisetests")) {
                    logSummariseTests = true;
                    continue;
                }
                if (pargs.ifMatch("loganalyse")) {
                    new LogAnalysis().process(pargs.next(), logShowLong, logShowMissingTaskIds, logSummariseTests);
                    return;
                }
                if (pargs.ifMatch("access")) {
                    new AccessLogs().analyze(pargs.next());
                    return;
                }
                if (pargs.ifMatch("url")) {
                    url = pargs.next();
                    continue;
                }
                if (pargs.ifMatch("jmxUrl")) {
                    jmxUrl = pargs.next();
                    continue;
                }
                if (pargs.ifMatch("-id")) {
                    id = pargs.next();
                    continue;
                }
                if (pargs.ifMatch("-pw")) {
                    pw = pargs.next();
                    continue;
                }
                if (pargs.ifMatch("-cmds")) {
                    cmdFile = pargs.next();
                    continue;
                }
                if (pargs.ifMatch("-cmd")) {
                    cmd = pargs.next();
                    continue;
                }
                BwCli.usage("Illegal argument: " + pargs.current());
                return;
            }
            BwCli jc = new BwCli(url, jmxUrl, id, pw, debug);
            if (cmdFile != null) {
                jc.setSingleCmd("sou \"" + cmd + "\"");
            } else if (cmd != null) {
                jc.setSingleCmd(cmd);
            }
            jc.processCmds();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void usage(String msg) {
        if (msg != null) {
            System.err.println();
            System.err.println(msg);
        }
        System.err.println();
        System.err.println("Optional arguments:");
        System.err.println("   url <url>          Url of the jolokia jmx service");
        System.err.println("   -cmds <qstring>    A path to a file of commands");
        System.err.println("   -cmd  <qstring>    A single quoted command to execute");
        System.err.println("   debug              To enable debug traces");
        System.err.println("   access             Analyze access log");
        System.err.println("   logshowlong        To enable display of long requests                      in loganalyse");
        System.err.println("   [logsummarisetests] loganalyse <path>                        Calculate and display information                      from referenced log file. If                      logsummarisetests is present then                       display a summary to help when                      running the tests");
    }

    public static class WebClient {
        private final String url;
        private HttpClient cl;
        private final ObjectMapper om;

        WebClient(String url) {
            this.url = url;
            this.om = new JsonMapper();
        }

        public HttpClient getCl() {
            if (this.cl != null) {
                return this.cl;
            }
            try {
                this.cl = new HttpClient(new URI(this.url));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            return this.cl;
        }
    }
}

