/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwcli.bwcmd;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bedework.bwcli.JsonMapper;
import org.bedework.util.http.Headers;
import org.bedework.util.http.PooledHttpClient;
import org.bedework.util.misc.Util;

public class HttpClient
extends PooledHttpClient {
    public HttpClient(URI uri) throws Exception {
        super(uri, (ObjectMapper)new JsonMapper());
        this.setHeadersFetcher(this::getHeaders);
    }

    private Headers getHeaders() {
        Headers hdrs = new Headers();
        return hdrs;
    }

    private String encode(String val) throws Throwable {
        return URLEncoder.encode(val, StandardCharsets.UTF_8);
    }

    private static class ReqBldr {
        final StringBuilder req = new StringBuilder();
        String delim = "?";

        ReqBldr(String path) {
            this.req.append(path);
        }

        void par(String name, String value) {
            this.req.append(this.delim);
            this.delim = "&";
            this.req.append(name);
            this.req.append("=");
            this.req.append(value);
        }

        void par(String name, int value) {
            this.par(name, String.valueOf(value));
        }

        void par(String name, boolean value) {
            this.par(name, String.valueOf(value));
        }

        void multiPar(String name, String[] value) throws Throwable {
            if (value == null || value.length == 0) {
                return;
            }
            for (String s : value) {
                this.par(name, s);
            }
        }

        void multiPar(String name, List<String> value) throws Throwable {
            if (Util.isEmpty(value)) {
                return;
            }
            for (String s : value) {
                this.par(name, ReqBldr.encode(s));
            }
        }

        void par(String name, List<String> value) throws Throwable {
            if (Util.isEmpty(value)) {
                return;
            }
            this.req.append(this.delim);
            this.delim = "&";
            this.req.append(name);
            this.req.append("=");
            String listDelim = "";
            StringBuilder sb = new StringBuilder();
            for (String s : value) {
                sb.append(listDelim);
                sb.append(s);
                listDelim = ",";
            }
            this.req.append(URLEncoder.encode(sb.toString(), StandardCharsets.UTF_8));
        }

        public String toString() {
            return this.req.toString();
        }

        private static String encode(String val) throws Throwable {
            return URLEncoder.encode(val, StandardCharsets.UTF_8);
        }
    }
}

