/* ********************************************************************
    Licensed to Jasig under one or more contributor license
    agreements. See the NOTICE file distributed with this work
    for additional information regarding copyright ownership.
    Jasig licenses this file to you under the Apache License,
    Version 2.0 (the "License"); you may not use this file
    except in compliance with the License. You may obtain a
    copy of the License at:

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied. See the License for the
    specific language governing permissions and limitations
    under the License.
*/
package org.bedework.synch.shared;

/** Some definitions for the synch service
 *
 *   @author Mike Douglass   douglm@rpi.edu
 */
public interface SynchDefs {
  /** and does it tell us when something changes or do we have to ask?
   */
  public enum SynchKind {
    /** we have to ask */
    poll,

    /** the other end will tell us via a callback */
    notify
  }

  /** Namespace of the synch SOAP service
   */
  static final String synchNamespace = "http://www.bedework.org/synch/wsmessages";
}
