/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.config;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.bedework.util.config.ConfigBase;
import org.bedework.util.config.ConfigException;
import org.bedework.util.config.ConfigurationStore;
import org.bedework.util.config.FileResourceControl;
import org.bedework.util.misc.Util;

public class ConfigurationFileStore
implements ConfigurationStore {
    private final Path dirPath;
    private ResourceBundle.Control resourceControl;

    public ConfigurationFileStore(Path dirPath) {
        this.dirPath = dirPath;
    }

    @Override
    public boolean readOnly() {
        return false;
    }

    @Override
    public Path getDirPath() {
        return this.dirPath;
    }

    @Override
    public void saveConfiguration(ConfigBase<?> config) throws ConfigException {
        try {
            File f = new File(this.dirPath + config.getName() + ".xml");
            FileWriter fw = new FileWriter(f);
            config.toXml(fw);
            fw.close();
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new ConfigException(t);
        }
    }

    @Override
    public ConfigBase<?> getConfig(String name) throws ConfigException {
        return this.getConfig(name, null);
    }

    @Override
    public ConfigBase<?> getConfig(String name, Class<?> cl) throws ConfigException {
        FileInputStream fis = null;
        try {
            Path fPath = this.dirPath.resolve(name + ".xml");
            File f = fPath.toFile();
            if (!f.exists()) {
                throw new ConfigException("Configuration " + fPath + " does not exist");
            }
            fis = new FileInputStream(f);
            ConfigBase configBase = new ConfigBase().fromXml(fis, cl);
            return configBase;
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new ConfigException(t);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public File getDirFile() {
        return this.dirPath.toFile();
    }

    @Override
    public List<String> getConfigs() throws ConfigException {
        File dir = this.getDirFile();
        File[] files = dir.listFiles(new FilesOnly());
        ArrayList<String> names = new ArrayList<String>();
        if (files == null) {
            throw new ConfigException("No configuration files in " + this.dirPath);
        }
        for (File f : files) {
            String nm = f.getName();
            names.add(nm.substring(0, nm.indexOf(".xml")));
        }
        return names;
    }

    @Override
    public ConfigurationStore getStore(String name) throws ConfigException {
        return new ConfigurationFileStore(this.ensureDir(this.dirPath.resolve(name)));
    }

    @Override
    public ResourceBundle getResource(String name, String locale) throws ConfigException {
        try {
            if (this.resourceControl == null) {
                this.resourceControl = new FileResourceControl(this.dirPath);
            }
            Locale loc = locale == null ? Locale.getDefault() : Util.makeLocale((String)locale);
            return ResourceBundle.getBundle(name, loc, this.resourceControl);
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new ConfigException(t);
        }
    }

    private static class DirsOnly
    implements FileFilter {
        private DirsOnly() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    private static class FilesOnly
    implements FileFilter {
        private FilesOnly() {
        }

        @Override
        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            return pathname.getName().endsWith(".xml");
        }
    }
}

