/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.config;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.ResourceBundle;
import org.bedework.util.config.ConfigBase;
import org.bedework.util.config.ConfigException;

public interface ConfigurationStore {
    public boolean readOnly();

    public Path getDirPath();

    public void saveConfiguration(ConfigBase<?> var1) throws ConfigException;

    public ConfigBase<?> getConfig(String var1) throws ConfigException;

    public ConfigBase<?> getConfig(String var1, Class<?> var2) throws ConfigException;

    public List<String> getConfigs() throws ConfigException;

    public ConfigurationStore getStore(String var1) throws ConfigException;

    public ResourceBundle getResource(String var1, String var2) throws ConfigException;

    default public Path ensureDir(Path path) throws ConfigException {
        File f = path.toFile();
        if (!f.exists()) {
            throw new ConfigException("No configuration directory at " + f.getAbsolutePath());
        }
        if (!f.isDirectory()) {
            throw new ConfigException(f.getAbsolutePath() + " is not a directory");
        }
        return path;
    }
}

