/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.logging;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class BwLogger {
    protected Class<?> loggedClass;
    protected String loggedName;
    private transient Logger log;
    private final Map<String, Logger> loggers = new HashMap<String, Logger>(5);
    public static final String errorLoggerName = "errors";
    public static final String auditLoggerName = "audit";
    public static final String metricsLoggerName = "metrics";
    private static final Map<String, Level> toLog4jLevel = new HashMap<String, Level>();
    private static final Map<Level, java.util.logging.Level> fromLog4jLevel;

    public BwLogger setLoggedClass(Class<?> cl) {
        this.loggedClass = cl;
        return this;
    }

    public Class<?> getLoggedClass() {
        return this.loggedClass;
    }

    public BwLogger setLoggedName(String name) {
        this.loggedName = name;
        return this;
    }

    public String getLoggedName() {
        return this.loggedName;
    }

    public void setLogLevel(String className, java.util.logging.Level level) {
        Level newLevel = toLog4jLevel.get(level.getName());
        if (newLevel == null) {
            return;
        }
        Logger log = Logger.getLogger((String)className);
        log.setLevel(newLevel);
        Logger rootLog = Logger.getRootLogger();
        Level rootLevel = rootLog.getLevel();
        if (newLevel.toInt() > rootLevel.toInt()) {
            rootLog.setLevel(newLevel);
        }
    }

    public java.util.logging.Level getLogLevel(String className) {
        java.util.logging.Level level = fromLog4jLevel.get(this.getLogger(className).getLevel());
        if (level == null) {
            return java.util.logging.Level.INFO;
        }
        return level;
    }

    protected Logger getLogger() {
        assert (this.loggedClass != null || this.loggedName != null);
        if (this.log == null) {
            this.log = this.loggedClass != null ? Logger.getLogger(this.loggedClass) : Logger.getLogger((String)this.loggedName);
        }
        return this.log;
    }

    protected Logger getLogger(String name) {
        Logger theLogger = this.loggers.get(name);
        if (theLogger != null) {
            return theLogger;
        }
        theLogger = Logger.getLogger((String)(name + "." + this.loggedClass.getName()));
        this.loggers.put(name, theLogger);
        return theLogger;
    }

    protected Logger getErrorLoggerIfEnabled() {
        return this.loggers.get(errorLoggerName);
    }

    protected Logger getAuditLoggerIfEnabled() {
        return this.loggers.get(auditLoggerName);
    }

    protected Logger getMetricsLoggerIfEnabled() {
        return this.loggers.get(metricsLoggerName);
    }

    public void enableErrorLogger() {
        this.getLogger(errorLoggerName);
    }

    public void enableAuditLogger() {
        this.getLogger(auditLoggerName);
    }

    public void enableMetricsLogger() {
        this.getLogger(metricsLoggerName);
    }

    public boolean debug() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isMetricsDebugEnabled() {
        return this.getLogger(metricsLoggerName).isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public boolean isErrorLoggerEnabled() {
        return this.getLogger(errorLoggerName) != null;
    }

    public boolean isAuditLoggerEnabled() {
        return this.getLogger(auditLoggerName) != null;
    }

    public boolean isMetricsLoggerEnabled() {
        return this.getLogger(metricsLoggerName) != null;
    }

    public void error(Throwable t) {
        this.getLogger().error((Object)t.getLocalizedMessage(), t);
        Logger errorLogger = this.getErrorLoggerIfEnabled();
        if (errorLogger != null) {
            errorLogger.error((Object)t.getLocalizedMessage(), t);
        }
    }

    public void error(String msg) {
        this.getLogger().error((Object)msg);
        Logger errorLogger = this.getErrorLoggerIfEnabled();
        if (errorLogger != null) {
            errorLogger.error((Object)msg);
        }
    }

    public void error(String msg, Throwable t) {
        this.getLogger().error((Object)msg, t);
        Logger errorLogger = this.getErrorLoggerIfEnabled();
        if (errorLogger != null) {
            errorLogger.error((Object)msg, t);
        }
    }

    public void warn(String msg) {
        this.getLogger().warn((Object)msg);
    }

    public void info(String msg) {
        this.getLogger().info((Object)msg);
    }

    public void audit(String msg) {
        if (this.isAuditLoggerEnabled()) {
            this.getLogger(auditLoggerName).info((Object)msg);
        }
    }

    public void metrics(String msg) {
        if (this.isMetricsLoggerEnabled()) {
            this.getLogger(metricsLoggerName).info((Object)msg);
        }
    }

    public void debug(String msg) {
        this.getLogger().debug((Object)msg);
    }

    public void trace(String msg) {
        this.getLogger().trace((Object)msg);
    }

    static {
        toLog4jLevel.put("OFF", Level.OFF);
        toLog4jLevel.put("SEVERE", Level.ERROR);
        toLog4jLevel.put("WARNING", Level.WARN);
        toLog4jLevel.put("INFO", Level.INFO);
        toLog4jLevel.put("CONFIG", Level.DEBUG);
        toLog4jLevel.put("FINE", Level.DEBUG);
        toLog4jLevel.put("FINER", Level.DEBUG);
        toLog4jLevel.put("FINEST", Level.TRACE);
        toLog4jLevel.put("ALL", Level.ALL);
        fromLog4jLevel = new HashMap<Level, java.util.logging.Level>();
        fromLog4jLevel.put(Level.OFF, java.util.logging.Level.OFF);
        fromLog4jLevel.put(Level.ERROR, java.util.logging.Level.SEVERE);
        fromLog4jLevel.put(Level.FATAL, java.util.logging.Level.SEVERE);
        fromLog4jLevel.put(Level.WARN, java.util.logging.Level.WARNING);
        fromLog4jLevel.put(Level.INFO, java.util.logging.Level.INFO);
        fromLog4jLevel.put(Level.DEBUG, java.util.logging.Level.FINE);
        fromLog4jLevel.put(Level.TRACE, java.util.logging.Level.FINEST);
        fromLog4jLevel.put(Level.ALL, java.util.logging.Level.ALL);
    }
}

