/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.logging;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BwLogger {
    protected Class<?> loggedClass;
    protected String loggedName;
    private transient Logger log;
    private final Map<String, Logger> loggers = new HashMap<String, Logger>(5);
    public static final String errorLoggerName = "errors";
    public static final String auditLoggerName = "audit";
    public static final String metricsLoggerName = "metrics";
    private static final Map<Level, java.util.logging.Level> fromLog4jLevel = new HashMap<Level, java.util.logging.Level>();

    public BwLogger setLoggedClass(Class<?> cl) {
        this.loggedClass = cl;
        return this;
    }

    public Class<?> getLoggedClass() {
        return this.loggedClass;
    }

    public BwLogger setLoggedName(String name) {
        this.loggedName = name;
        return this;
    }

    public String getLoggedName() {
        return this.loggedName;
    }

    public java.util.logging.Level getLogLevel(String className) {
        java.util.logging.Level level = fromLog4jLevel.get(this.getLogger(className).getLevel());
        if (level == null) {
            return java.util.logging.Level.INFO;
        }
        return level;
    }

    protected Logger getLogger() {
        assert (this.loggedClass != null || this.loggedName != null);
        if (this.log == null) {
            this.log = this.loggedClass != null ? LogManager.getLogger(this.loggedClass) : LogManager.getLogger((String)this.loggedName);
        }
        return this.log;
    }

    protected Logger getLogger(String name) {
        Logger theLogger = this.loggers.get(name);
        if (theLogger != null) {
            return theLogger;
        }
        theLogger = LogManager.getLogger((String)(name + "." + this.loggedClass.getName()));
        this.loggers.put(name, theLogger);
        return theLogger;
    }

    protected Logger getErrorLoggerIfEnabled() {
        return this.loggers.get(errorLoggerName);
    }

    protected Logger getAuditLoggerIfEnabled() {
        return this.loggers.get(auditLoggerName);
    }

    protected Logger getMetricsLoggerIfEnabled() {
        return this.loggers.get(metricsLoggerName);
    }

    public void enableErrorLogger() {
        this.getLogger(errorLoggerName);
    }

    public void enableAuditLogger() {
        this.getLogger(auditLoggerName);
    }

    public void enableMetricsLogger() {
        this.getLogger(metricsLoggerName);
    }

    public boolean debug() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isMetricsDebugEnabled() {
        return this.getLogger(metricsLoggerName).isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public boolean isErrorLoggerEnabled() {
        return this.getLogger(errorLoggerName) != null;
    }

    public boolean isAuditLoggerEnabled() {
        return this.getLogger(auditLoggerName) != null;
    }

    public boolean isMetricsLoggerEnabled() {
        return this.getLogger(metricsLoggerName) != null;
    }

    public void error(Throwable t) {
        this.getLogger().error(t.getLocalizedMessage(), t);
        Logger errorLogger = this.getErrorLoggerIfEnabled();
        if (errorLogger != null) {
            errorLogger.error(t.getLocalizedMessage(), t);
        }
    }

    public void error(String msg) {
        this.getLogger().error(msg);
        Logger errorLogger = this.getErrorLoggerIfEnabled();
        if (errorLogger != null) {
            errorLogger.error(msg);
        }
    }

    public void error(String msg, Throwable t) {
        this.getLogger().error(msg, t);
        Logger errorLogger = this.getErrorLoggerIfEnabled();
        if (errorLogger != null) {
            errorLogger.error(msg, t);
        }
    }

    public void warn(String msg) {
        this.getLogger().warn(msg);
    }

    public void info(String msg) {
        this.getLogger().info(msg);
    }

    public void audit(String msg) {
        if (this.isAuditLoggerEnabled()) {
            this.getLogger(auditLoggerName).info(msg);
        }
    }

    public void metrics(String msg) {
        if (this.isMetricsLoggerEnabled()) {
            this.getLogger(metricsLoggerName).info(msg);
        }
    }

    public void debug(String msg) {
        this.getLogger().debug(msg);
    }

    public void trace(String msg) {
        this.getLogger().trace(msg);
    }

    static {
        fromLog4jLevel.put(Level.OFF, java.util.logging.Level.OFF);
        fromLog4jLevel.put(Level.ERROR, java.util.logging.Level.SEVERE);
        fromLog4jLevel.put(Level.FATAL, java.util.logging.Level.SEVERE);
        fromLog4jLevel.put(Level.WARN, java.util.logging.Level.WARNING);
        fromLog4jLevel.put(Level.INFO, java.util.logging.Level.INFO);
        fromLog4jLevel.put(Level.DEBUG, java.util.logging.Level.FINE);
        fromLog4jLevel.put(Level.TRACE, java.util.logging.Level.FINEST);
        fromLog4jLevel.put(Level.ALL, java.util.logging.Level.ALL);
    }
}

