/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.bedework.util.logging.Logged;
import org.bedework.util.servlet.HttpServletUtils;

public interface HttpAppLogger
extends Logged {
    default public LogEntry getLogEntry(HttpServletRequest request, String logname) {
        return new LogEntry(request, new StringBuffer(logname), this);
    }

    default public void logInfo(HttpServletRequest request, String logname, String info) {
        LogEntry le = this.getLogEntry(request, logname);
        le.append(info);
        le.emit();
    }

    default public void logRequest(HttpServletRequest request) throws Throwable {
        LogEntry le = this.getLogEntry(request, "REQUEST");
        le.append(request.getRemoteAddr());
        le.append(HttpServletUtils.getUrl(request));
        String q = request.getQueryString();
        if (q != null) {
            le.concat("?");
            le.concat(q);
        }
        le.header("Referer");
        le.header("X-Forwarded-For");
        le.emit();
    }

    default public void logRequestOut(HttpServletRequest request) throws Throwable {
        LogEntry le = this.getLogEntry(request, "REQUEST-OUT");
        le.append(request.getRemoteAddr());
        le.append(HttpServletUtils.getUrl(request));
        String q = request.getQueryString();
        if (q != null) {
            le.concat("?");
            le.concat(q);
        }
        le.header("Referer");
        le.header("X-Forwarded-For");
        le.emit();
    }

    default public void logSessionCounts(HttpServletRequest request, boolean start, long sessionNum, long sessions) {
        LogEntry le = start ? this.getLogEntry(request, "SESSION-START") : this.getLogEntry(request, "SESSION-END");
        le.append(String.valueOf(sessionNum));
        le.append(String.valueOf(sessions));
        le.emit();
    }

    public String getLogPrefix(HttpServletRequest var1);

    default public String getSessionId(HttpServletRequest request) {
        try {
            HttpSession sess = request.getSession(false);
            if (sess == null) {
                return "NO-SESSIONID";
            }
            return sess.getId();
        }
        catch (Throwable t) {
            this.error(t);
            return "SESSION-ID-EXCEPTION";
        }
    }

    default public void emitLogEntry(LogEntry entry) {
        this.info(entry.toString());
    }

    public static class LogEntry {
        final HttpServletRequest request;
        StringBuffer sb;
        HttpAppLogger logger;

        public LogEntry(HttpServletRequest request, StringBuffer sb, HttpAppLogger logger) {
            this.request = request;
            this.sb = sb;
            this.logger = logger;
            sb.append(":");
            sb.append(logger.getSessionId(request));
            sb.append(":");
            sb.append(logger.getLogPrefix(request));
            sb.append(":charset=");
            sb.append(request.getCharacterEncoding());
        }

        public void append(String val) {
            this.sb.append(":");
            this.sb.append(val);
        }

        public void concat(String val) {
            this.sb.append(val);
        }

        public void header(String name) {
            String val = this.request.getHeader(name);
            if (val == null) {
                val = "NONE";
            }
            this.sb.append(" - ");
            this.sb.append(name);
            this.sb.append(":");
            this.sb.append(val);
        }

        public void emit() {
            this.logger.emitLogEntry(this);
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

